/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleLongHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;

public class DoubleLongMaxHeap
implements DoubleLongHeap {
    protected double[] twoheap;
    protected long[] twovals;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public DoubleLongMaxHeap() {
        double[] dArray = new double[31];
        long[] lArray = new long[31];
        this.twoheap = dArray;
        this.twovals = lArray;
    }

    public DoubleLongMaxHeap(int n) {
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        double[] dArray = new double[n2];
        long[] lArray = new long[n2];
        this.twoheap = dArray;
        this.twovals = lArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0.0);
        Arrays.fill(this.twovals, 0L);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(double d, long l) {
        double d2 = d;
        long l2 = l;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
            this.twovals = Arrays.copyOf(this.twovals, this.twovals.length + this.twovals.length + 1);
        }
        int n = this.size++;
        this.twoheap[n] = d2;
        this.twovals[n] = l2;
        this.heapifyUp(n, d2, l2);
    }

    @Override
    public void add(double d, long l, int n) {
        if (this.size < n) {
            this.add(d, l);
        } else if (this.twoheap[0] > d) {
            this.replaceTopElement(d, l);
        }
    }

    @Override
    public void replaceTopElement(double d, long l) {
        this.heapifyDown(d, l);
    }

    private void heapifyUp(int n, double d, long l) {
        int n2;
        double d2;
        while (n > 0 && !(d <= (d2 = this.twoheap[n2 = n - 1 >>> 1]))) {
            this.twoheap[n] = d2;
            this.twovals[n] = this.twovals[n2];
            n = n2;
        }
        this.twoheap[n] = d;
        this.twovals[n] = l;
    }

    @Override
    public void poll() {
        --this.size;
        if (this.size > 0) {
            double d = this.twoheap[this.size];
            long l = this.twovals[this.size];
            this.twoheap[this.size] = 0.0;
            this.twovals[this.size] = 0L;
            this.heapifyDown(d, l);
        } else {
            this.twoheap[0] = 0.0;
            this.twovals[0] = 0L;
        }
    }

    private void heapifyDown(double d, long l) {
        int n = this.size >>> 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = (n2 << 1) + 1;
            double d2 = this.twoheap[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && d2 < this.twoheap[n4]) {
                n3 = n4;
                d2 = this.twoheap[n4];
            }
            if (d >= d2) break;
            this.twoheap[n2] = d2;
            this.twovals[n2] = this.twovals[n3];
            n2 = n3;
        }
        this.twoheap[n2] = d;
        this.twovals[n2] = l;
    }

    @Override
    public double peekKey() {
        return this.twoheap[0];
    }

    @Override
    public long peekValue() {
        return this.twovals[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DoubleLongMaxHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.getKey()).append(':').append(unsortedIter.getValue()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements DoubleLongHeap.UnsortedIter {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleLongMaxHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double getKey() {
            return DoubleLongMaxHeap.this.twoheap[this.pos];
        }

        @Override
        public long getValue() {
            return DoubleLongMaxHeap.this.twovals[this.pos];
        }
    }
}

