/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnusedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class ClassParameter<C>
extends AbstractParameter<ClassParameter<C>, Class<? extends C>> {
    private static final Logging LOG = Logging.getLogger(ClassParameter.class);
    protected Class<C> restrictionClass;

    public ClassParameter(OptionID optionID, Class<?> clazz, Class<?> clazz2) {
        super(optionID, clazz2);
        this.restrictionClass = clazz;
        if (clazz == null) {
            LoggingUtil.warning("Restriction class 'null' for parameter '" + optionID + "'", new Throwable());
        }
    }

    public ClassParameter(OptionID optionID, Class<?> clazz, boolean bl) {
        super(optionID, bl);
        this.restrictionClass = clazz;
        if (clazz == null) {
            LoggingUtil.warning("Restriction class 'null' for parameter '" + optionID + "'", new Throwable());
        }
    }

    public ClassParameter(OptionID optionID, Class<?> clazz) {
        this(optionID, clazz, false);
    }

    @Override
    protected Class<? extends C> parseValue(Object object) throws ParameterException {
        Class<C> clazz;
        if (object == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (object instanceof Class) {
            return (Class)object;
        }
        if (object instanceof String && (clazz = ELKIServiceRegistry.findImplementation(this.restrictionClass, (String)object)) != null) {
            return clazz;
        }
        throw new WrongParameterValueException(this, object.toString(), "Class not found for given value. Must be a subclass / implementation of " + this.restrictionClass.getName());
    }

    @Override
    public boolean validate(Class<? extends C> clazz) throws ParameterException {
        if (clazz == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (!this.restrictionClass.isAssignableFrom(clazz)) {
            throw new WrongParameterValueException(this, clazz.getName(), "Given class not a subclass / implementation of " + this.restrictionClass.getName());
        }
        return super.validate(clazz);
    }

    @Override
    public String getSyntax() {
        return "<class>";
    }

    @Override
    public boolean hasValuesDescription() {
        return this.restrictionClass != null && this.restrictionClass != Object.class;
    }

    @Override
    public String getValuesDescription() {
        if (this.restrictionClass != null && this.restrictionClass != Object.class) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.restrictionClass.isInterface()) {
                stringBuilder.append("Implementing ");
            } else {
                stringBuilder.append("Extending ");
            }
            stringBuilder.append(this.restrictionClass.getName());
            stringBuilder.append(FormatUtil.NEWLINE);
            List<Class<?>> list = this.getKnownImplementations();
            if (!list.isEmpty()) {
                stringBuilder.append("Known classes (default package " + this.restrictionClass.getPackage().getName() + "):");
                stringBuilder.append(FormatUtil.NEWLINE);
                for (Class<?> clazz : list) {
                    stringBuilder.append("->").append("\u00a0");
                    stringBuilder.append(ClassParameter.canonicalClassName(clazz, this.getRestrictionClass()));
                    stringBuilder.append(FormatUtil.NEWLINE);
                }
            }
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public String getValueAsString() {
        return ClassParameter.canonicalClassName((Class)this.getValue(), this.getRestrictionClass());
    }

    public C instantiateClass(Parameterization parameterization) {
        try {
            C c;
            if (this.getValue() == null) {
                throw new UnusedParameterException("Value of parameter " + this.getName() + " has not been specified.");
            }
            try {
                parameterization = parameterization.descend(this);
                c = ClassGenericsUtil.tryInstantiate(this.restrictionClass, (Class)this.getValue(), parameterization);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WrongParameterValueException(this, ((Class)this.getValue()).getCanonicalName(), "Error instantiating class.", invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new WrongParameterValueException(this, ((Class)this.getValue()).getCanonicalName(), "Error instantiating class - no usable public constructor.");
            }
            catch (Exception exception) {
                if (LOG.isVerbose()) {
                    LOG.exception("Class initialization failed.", exception);
                }
                throw new WrongParameterValueException(this, ((Class)this.getValue()).getCanonicalName(), "Error instantiating class.", exception);
            }
            return c;
        }
        catch (ParameterException parameterException) {
            parameterization.reportError(parameterException);
            return null;
        }
    }

    public Class<C> getRestrictionClass() {
        return this.restrictionClass;
    }

    public List<Class<?>> getKnownImplementations() {
        return ELKIServiceRegistry.findAllImplementations(this.getRestrictionClass());
    }

    public static String canonicalClassName(Class<?> clazz, Package package_, String string) {
        String string2;
        String string3 = clazz.getName();
        if (package_ != null && string3.startsWith(string2 = package_.getName() + ".")) {
            string3 = string3.substring(string2.length());
        }
        if (string != null && string3.endsWith(string)) {
            string3 = string3.substring(0, string3.length() - string.length());
        }
        return string3;
    }

    public static String canonicalClassName(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null) {
            return ClassParameter.canonicalClassName(clazz, null, "$Factory");
        }
        return ClassParameter.canonicalClassName(clazz, clazz2.getPackage(), "$Factory");
    }

    @Override
    public String getDefaultValueAsString() {
        return ClassParameter.canonicalClassName((Class)this.getDefaultValue(), this.getRestrictionClass());
    }
}

