/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonNames;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.CreateMapForCacheKt;
import kotlinx.serialization.json.internal.DescriptorSchemaCache;
import kotlinx.serialization.json.internal.JsonException;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0018\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u00020\nH\u0000\u001a\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u000f\u001a\u00020\u0004*\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001aF\u0010\u0010\u001a\u00020\u0011*\u00020\r2\u0006\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00142\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0080\b\u00f8\u0001\u0000\".\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"JsonAlternativeNamesKey", "Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "", "", "", "getJsonAlternativeNamesKey$annotations", "()V", "getJsonAlternativeNamesKey", "()Lkotlinx/serialization/json/internal/DescriptorSchemaCache$Key;", "buildAlternativeNamesMap", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getJsonNameIndex", "json", "Lkotlinx/serialization/json/Json;", "name", "getJsonNameIndexOrThrow", "tryCoerceValue", "", "elementDescriptor", "peekNull", "Lkotlin/Function0;", "peekString", "onEnumCoercing", "", "kotlinx-serialization-json"})
public final class JsonNamesMapKt {
    @NotNull
    private static final DescriptorSchemaCache.Key<Map<String, Integer>> JsonAlternativeNamesKey = new DescriptorSchemaCache.Key();

    @NotNull
    public static final DescriptorSchemaCache.Key<Map<String, Integer>> getJsonAlternativeNamesKey() {
        return JsonAlternativeNamesKey;
    }

    public static /* synthetic */ void getJsonAlternativeNamesKey$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Integer> buildAlternativeNamesMap(@NotNull SerialDescriptor $this$buildAlternativeNamesMap) {
        Map<String, Integer> map;
        Intrinsics.checkNotNullParameter((Object)$this$buildAlternativeNamesMap, (String)"<this>");
        Map<String, Integer> builder = null;
        int n = 0;
        int n2 = $this$buildAlternativeNamesMap.getElementsCount();
        if (n < n2) {
            do {
                String[] stringArray;
                void $this$filterIsInstanceTo$iv$iv;
                int i = n++;
                Iterable $this$filterIsInstance$iv = $this$buildAlternativeNamesMap.getElementAnnotations(i);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JsonNames)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                JsonNames jsonNames = (JsonNames)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                if (jsonNames == null || (stringArray = jsonNames.names()) == null) continue;
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                String[] stringArray2 = $this$forEach$iv;
                int n3 = stringArray2.length;
                for (int j = 0; j < n3; ++j) {
                    String element$iv;
                    String name = element$iv = stringArray2[j];
                    boolean bl = false;
                    if (builder == null) {
                        builder = CreateMapForCacheKt.createMapForCache($this$buildAlternativeNamesMap.getElementsCount());
                    }
                    Map<String, Integer> map2 = builder;
                    Intrinsics.checkNotNull(map2);
                    JsonNamesMapKt.buildAlternativeNamesMap$putOrThrow(map2, $this$buildAlternativeNamesMap, name, i);
                }
            } while (n < n2);
        }
        return (map = builder) == null ? MapsKt.emptyMap() : map;
    }

    public static final int getJsonNameIndex(@NotNull SerialDescriptor $this$getJsonNameIndex, @NotNull Json json, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsonNameIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int index = $this$getJsonNameIndex.getElementIndex(name);
        if (index != -3) {
            return index;
        }
        if (!json.getConfiguration().getUseAlternativeNames()) {
            return index;
        }
        Map<String, Integer> alternativeNamesMap2 = JsonSchemaCacheKt.getSchemaCache(json).getOrPut($this$getJsonNameIndex, JsonAlternativeNamesKey, (Function0)new Function0<Map<String, ? extends Integer>>((Object)$this$getJsonNameIndex){

            @NotNull
            public final Map<String, Integer> invoke() {
                return JsonNamesMapKt.buildAlternativeNamesMap((SerialDescriptor)this.receiver);
            }
        });
        Integer n = alternativeNamesMap2.get(name);
        return n == null ? -3 : n;
    }

    public static final int getJsonNameIndexOrThrow(@NotNull SerialDescriptor $this$getJsonNameIndexOrThrow, @NotNull Json json, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$getJsonNameIndexOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int index = JsonNamesMapKt.getJsonNameIndex($this$getJsonNameIndexOrThrow, json, name);
        if (index == -3) {
            throw new SerializationException($this$getJsonNameIndexOrThrow.getSerialName() + " does not contain element with name '" + name + '\'');
        }
        return index;
    }

    public static final boolean tryCoerceValue(@NotNull Json $this$tryCoerceValue, @NotNull SerialDescriptor elementDescriptor, @NotNull Function0<Boolean> peekNull, @NotNull Function0<String> peekString, @NotNull Function0<Unit> onEnumCoercing) {
        Intrinsics.checkNotNullParameter((Object)$this$tryCoerceValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elementDescriptor, (String)"elementDescriptor");
        Intrinsics.checkNotNullParameter(peekNull, (String)"peekNull");
        Intrinsics.checkNotNullParameter(peekString, (String)"peekString");
        Intrinsics.checkNotNullParameter(onEnumCoercing, (String)"onEnumCoercing");
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor.isNullable() && ((Boolean)peekNull.invoke()).booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)elementDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE)) {
            String string = (String)peekString.invoke();
            if (string == null) {
                return false;
            }
            String enumValue = string;
            int enumIndex = JsonNamesMapKt.getJsonNameIndex(elementDescriptor, $this$tryCoerceValue, enumValue);
            if (enumIndex == -3) {
                onEnumCoercing.invoke();
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean tryCoerceValue$default(Json $this$tryCoerceValue_u24default, SerialDescriptor elementDescriptor, Function0 peekNull, Function0 peekString, Function0 onEnumCoercing, int n, Object object) {
        if ((n & 8) != 0) {
            onEnumCoercing = tryCoerceValue.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)$this$tryCoerceValue_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)elementDescriptor, (String)"elementDescriptor");
        Intrinsics.checkNotNullParameter((Object)peekNull, (String)"peekNull");
        Intrinsics.checkNotNullParameter((Object)peekString, (String)"peekString");
        Intrinsics.checkNotNullParameter((Object)onEnumCoercing, (String)"onEnumCoercing");
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor.isNullable() && ((Boolean)peekNull.invoke()).booleanValue()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)elementDescriptor.getKind(), (Object)SerialKind.ENUM.INSTANCE)) {
            String string = (String)peekString.invoke();
            if (string == null) {
                return false;
            }
            String enumValue = string;
            int enumIndex = JsonNamesMapKt.getJsonNameIndex(elementDescriptor, $this$tryCoerceValue_u24default, enumValue);
            if (enumIndex == -3) {
                onEnumCoercing.invoke();
                return true;
            }
        }
        return false;
    }

    private static final void buildAlternativeNamesMap$putOrThrow(Map<String, Integer> $this$buildAlternativeNamesMap_u24putOrThrow, SerialDescriptor $this_buildAlternativeNamesMap, String name, int index) {
        Map<String, Integer> map = $this$buildAlternativeNamesMap_u24putOrThrow;
        boolean bl = false;
        Map<String, Integer> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(name)) {
            throw new JsonException("The suggested name '" + name + "' for property " + $this_buildAlternativeNamesMap.getElementName(index) + " is already one of the names for property " + $this_buildAlternativeNamesMap.getElementName(((Number)MapsKt.getValue($this$buildAlternativeNamesMap_u24putOrThrow, (Object)name)).intValue()) + " in " + $this_buildAlternativeNamesMap);
        }
        map = $this$buildAlternativeNamesMap_u24putOrThrow;
        Integer n = index;
        boolean bl3 = false;
        map.put(name, n);
    }
}

