/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.internal.Options;

public class Math {
    public static final double PI = java.lang.Math.PI;
    static final double PI2 = java.lang.Math.PI * 2;
    static final double PIHalf = 1.5707963267948966;
    static final double PI_4 = 0.7853981633974483;
    static final double PI_INV = 0.3183098861837907;
    private static final int lookupBits = Options.SIN_LOOKUP_BITS;
    private static final int lookupTableSize = 1 << lookupBits;
    private static final int lookupTableSizeMinus1 = lookupTableSize - 1;
    private static final int lookupTableSizeWithMargin = lookupTableSize + 1;
    private static final double pi2OverLookupSize = java.lang.Math.PI * 2 / (double)lookupTableSize;
    private static final double lookupSizeOverPi2 = (double)lookupTableSize / (java.lang.Math.PI * 2);
    private static final float[] sinTable;
    private static final double c1;
    private static final double c2;
    private static final double c3;
    private static final double c4;
    private static final double c5;
    private static final double c6;
    private static final double c7;
    private static final double s5;
    private static final double s4;
    private static final double s3;
    private static final double s2;
    private static final double s1;
    private static final double k1;
    private static final double k2;
    private static final double k3;
    private static final double k4;
    private static final double k5;
    private static final double k6;
    private static final double k7;

    static double sin_theagentd_arith(double x) {
        double xi = Math.floor((x + 0.7853981633974483) * 0.3183098861837907);
        double x_ = x - xi * java.lang.Math.PI;
        double sign = ((int)xi & 1) * -2 + 1;
        double x2 = x_ * x_;
        double sin = x_;
        double tx = x_ * x2;
        sin += tx * c1;
        sin += (tx *= x2) * c2;
        sin += (tx *= x2) * c3;
        sin += (tx *= x2) * c4;
        sin += (tx *= x2) * c5;
        sin += (tx *= x2) * c6;
        return sign * (sin += (tx *= x2) * c7);
    }

    static double sin_roquen_arith(double x) {
        double xi = Math.floor((x + 0.7853981633974483) * 0.3183098861837907);
        double x_ = x - xi * java.lang.Math.PI;
        double sign = ((int)xi & 1) * -2 + 1;
        double x2 = x_ * x_;
        x_ = sign * x_;
        double sin = c7;
        sin = sin * x2 + c6;
        sin = sin * x2 + c5;
        sin = sin * x2 + c4;
        sin = sin * x2 + c3;
        sin = sin * x2 + c2;
        sin = sin * x2 + c1;
        return x_ + x_ * x2 * sin;
    }

    static double sin_roquen_9(double v) {
        double i = java.lang.Math.rint(v * 0.3183098861837907);
        double x = v - i * java.lang.Math.PI;
        double qs = 1 - 2 * ((int)i & 1);
        double x2 = x * x;
        x = qs * x;
        double r = s5;
        r = r * x2 + s4;
        r = r * x2 + s3;
        r = r * x2 + s2;
        r = r * x2 + s1;
        return x * r;
    }

    static double sin_roquen_newk(double v) {
        double i = java.lang.Math.rint(v * 0.3183098861837907);
        double x = v - i * java.lang.Math.PI;
        double qs = 1 - 2 * ((int)i & 1);
        double x2 = x * x;
        x = qs * x;
        double r = k7;
        r = r * x2 + k6;
        r = r * x2 + k5;
        r = r * x2 + k4;
        r = r * x2 + k3;
        r = r * x2 + k2;
        r = r * x2 + k1;
        return x + x * x2 * r;
    }

    static double sin_theagentd_lookup(double rad) {
        float index = (float)(rad * lookupSizeOverPi2);
        int ii = (int)java.lang.Math.floor(index);
        float alpha = index - (float)ii;
        int i = ii & lookupTableSizeMinus1;
        float sin1 = sinTable[i];
        float sin2 = sinTable[i + 1];
        return sin1 + (sin2 - sin1) * alpha;
    }

    public static double sin(double rad) {
        if (Options.FASTMATH) {
            if (Options.SIN_LOOKUP) {
                return Math.sin_theagentd_lookup(rad);
            }
            return Math.sin_roquen_newk(rad);
        }
        return java.lang.Math.sin(rad);
    }

    public static double cos(double rad) {
        if (Options.FASTMATH) {
            return Math.sin(rad + 1.5707963267948966);
        }
        return java.lang.Math.cos(rad);
    }

    public static double cosFromSin(double sin, double angle) {
        if (Options.FASTMATH) {
            return Math.sin(angle + 1.5707963267948966);
        }
        double cos = Math.sqrt(1.0 - sin * sin);
        double a = angle + 1.5707963267948966;
        double b = a - (double)((int)(a / (java.lang.Math.PI * 2))) * (java.lang.Math.PI * 2);
        if (b < 0.0) {
            b = java.lang.Math.PI * 2 + b;
        }
        if (b >= java.lang.Math.PI) {
            return -cos;
        }
        return cos;
    }

    public static double sqrt(double r) {
        return java.lang.Math.sqrt(r);
    }

    public static double tan(double r) {
        return java.lang.Math.tan(r);
    }

    public static double acos(double r) {
        return java.lang.Math.acos(r);
    }

    public static double atan2(double y, double x) {
        return java.lang.Math.atan2(y, x);
    }

    public static double asin(double r) {
        return java.lang.Math.asin(r);
    }

    public static double abs(double r) {
        return java.lang.Math.abs(r);
    }

    public static float abs(float r) {
        return java.lang.Math.abs(r);
    }

    public static int abs(int r) {
        return java.lang.Math.abs(r);
    }

    public static int max(int x, int y) {
        return java.lang.Math.max(x, y);
    }

    public static int min(int x, int y) {
        return java.lang.Math.min(x, y);
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static double toRadians(double angles) {
        return java.lang.Math.toRadians(angles);
    }

    public static double toDegrees(double angles) {
        return java.lang.Math.toDegrees(angles);
    }

    public static double floor(double v) {
        return java.lang.Math.floor(v);
    }

    public static float floor(float v) {
        return (float)java.lang.Math.floor(v);
    }

    public static double ceil(double v) {
        return java.lang.Math.ceil(v);
    }

    public static float ceil(float v) {
        return (float)java.lang.Math.ceil(v);
    }

    public static long round(double v) {
        return java.lang.Math.round(v);
    }

    public static int round(float v) {
        return java.lang.Math.round(v);
    }

    public static double exp(double a) {
        return java.lang.Math.exp(a);
    }

    public static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    static {
        if (Options.FASTMATH && Options.SIN_LOOKUP) {
            sinTable = new float[lookupTableSizeWithMargin];
            for (int i = 0; i < lookupTableSizeWithMargin; ++i) {
                double d = (double)i * pi2OverLookupSize;
                Math.sinTable[i] = (float)java.lang.Math.sin(d);
            }
        } else {
            sinTable = null;
        }
        c1 = Double.longBitsToDouble(-4628199217061079772L);
        c2 = Double.longBitsToDouble(4575957461383582011L);
        c3 = Double.longBitsToDouble(-4671919876300759001L);
        c4 = Double.longBitsToDouble(4523617214285661942L);
        c5 = Double.longBitsToDouble(-4730215272828025532L);
        c6 = Double.longBitsToDouble(4460272573143870633L);
        c7 = Double.longBitsToDouble(-4797767418267846529L);
        s5 = Double.longBitsToDouble(4523227044276562163L);
        s4 = Double.longBitsToDouble(-4671934770969572232L);
        s3 = Double.longBitsToDouble(4575957211482072852L);
        s2 = Double.longBitsToDouble(-4628199223918090387L);
        s1 = Double.longBitsToDouble(4607182418589157889L);
        k1 = Double.longBitsToDouble(-4628199217061079959L);
        k2 = Double.longBitsToDouble(4575957461383549981L);
        k3 = Double.longBitsToDouble(-4671919876307284301L);
        k4 = Double.longBitsToDouble(4523617213632129738L);
        k5 = Double.longBitsToDouble(-4730215344060517252L);
        k6 = Double.longBitsToDouble(4460268259291226124L);
        k7 = Double.longBitsToDouble(-4798040743777455072L);
    }
}

