/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2dc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.internal.MemUtil;
import org.joml.internal.Options;
import org.joml.internal.Runtime;

public class Vector3d
implements Externalizable,
Vector3dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;

    public Vector3d() {
    }

    public Vector3d(double d) {
        this(d, d, d);
    }

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3d(Vector3fc v) {
        this(v.x(), v.y(), v.z());
    }

    public Vector3d(Vector3ic v) {
        this(v.x(), v.y(), v.z());
    }

    public Vector3d(Vector2fc v, double z) {
        this(v.x(), v.y(), z);
    }

    public Vector3d(Vector2ic v, double z) {
        this(v.x(), v.y(), z);
    }

    public Vector3d(Vector3dc v) {
        this(v.x(), v.y(), v.z());
    }

    public Vector3d(Vector2dc v, double z) {
        this(v.x(), v.y(), z);
    }

    public Vector3d(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3d(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector3d(DoubleBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3d(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    private Vector3d thisOrNew() {
        return this;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Vector3d set(Vector3dc v) {
        return this.set(v.x(), v.y(), v.z());
    }

    public Vector3d set(Vector3ic v) {
        return this.set(v.x(), v.y(), v.z());
    }

    public Vector3d set(Vector2dc v, double z) {
        return this.set(v.x(), v.y(), z);
    }

    public Vector3d set(Vector2ic v, double z) {
        return this.set(v.x(), v.y(), z);
    }

    public Vector3d set(Vector3fc v) {
        return this.set(v.x(), v.y(), v.z());
    }

    public Vector3d set(Vector2fc v, double z) {
        return this.set(v.x(), v.y(), z);
    }

    public Vector3d set(double d) {
        return this.set(d, d, d);
    }

    public Vector3d set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3d set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3d set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3d set(DoubleBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3d set(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3d setFromAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.get(this, address);
        return this;
    }

    public Vector3d setComponent(int component, double value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public DoubleBuffer get(DoubleBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public DoubleBuffer get(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer getf(ByteBuffer buffer) {
        return this.getf(buffer.position(), buffer);
    }

    public ByteBuffer getf(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.putf(this, index, buffer);
        return buffer;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector3dc getToAddress(long address) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe unsafe = (MemUtil.MemUtilUnsafe)MemUtil.INSTANCE;
        unsafe.put(this, address);
        return this;
    }

    public Vector3d sub(Vector3dc v) {
        return this.sub(v, this.thisOrNew());
    }

    public Vector3d sub(Vector3dc v, Vector3d dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        dest.z = this.z - v.z();
        return dest;
    }

    public Vector3d sub(Vector3fc v) {
        return this.sub(v, this.thisOrNew());
    }

    public Vector3d sub(Vector3fc v, Vector3d dest) {
        dest.x = this.x - (double)v.x();
        dest.y = this.y - (double)v.y();
        dest.z = this.z - (double)v.z();
        return dest;
    }

    public Vector3d sub(double x, double y, double z) {
        return this.sub(x, y, z, this.thisOrNew());
    }

    public Vector3d sub(double x, double y, double z, Vector3d dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        return dest;
    }

    public Vector3d add(Vector3dc v) {
        return this.add(v, this.thisOrNew());
    }

    public Vector3d add(Vector3dc v, Vector3d dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        dest.z = this.z + v.z();
        return dest;
    }

    public Vector3d add(Vector3fc v) {
        return this.add(v, this.thisOrNew());
    }

    public Vector3d add(Vector3fc v, Vector3d dest) {
        dest.x = this.x + (double)v.x();
        dest.y = this.y + (double)v.y();
        dest.z = this.z + (double)v.z();
        return dest;
    }

    public Vector3d add(double x, double y, double z) {
        return this.add(x, y, z, this.thisOrNew());
    }

    public Vector3d add(double x, double y, double z, Vector3d dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        return dest;
    }

    public Vector3d fma(Vector3dc a, Vector3dc b) {
        return this.fma(a, b, this.thisOrNew());
    }

    public Vector3d fma(double a, Vector3dc b) {
        return this.fma(a, b, this.thisOrNew());
    }

    public Vector3d fma(Vector3fc a, Vector3fc b) {
        return this.fma(a, b, this.thisOrNew());
    }

    public Vector3d fma(Vector3fc a, Vector3fc b, Vector3d dest) {
        dest.x = this.x + (double)(a.x() * b.x());
        dest.y = this.y + (double)(a.y() * b.y());
        dest.z = this.z + (double)(a.z() * b.z());
        return dest;
    }

    public Vector3d fma(double a, Vector3fc b) {
        return this.fma(a, b, this.thisOrNew());
    }

    public Vector3d fma(Vector3dc a, Vector3dc b, Vector3d dest) {
        dest.x = this.x + a.x() * b.x();
        dest.y = this.y + a.y() * b.y();
        dest.z = this.z + a.z() * b.z();
        return dest;
    }

    public Vector3d fma(double a, Vector3dc b, Vector3d dest) {
        dest.x = this.x + a * b.x();
        dest.y = this.y + a * b.y();
        dest.z = this.z + a * b.z();
        return dest;
    }

    public Vector3d fma(Vector3dc a, Vector3fc b, Vector3d dest) {
        dest.x = this.x + a.x() * (double)b.x();
        dest.y = this.y + a.y() * (double)b.y();
        dest.z = this.z + a.z() * (double)b.z();
        return dest;
    }

    public Vector3d fma(double a, Vector3fc b, Vector3d dest) {
        dest.x = this.x + a * (double)b.x();
        dest.y = this.y + a * (double)b.y();
        dest.z = this.z + a * (double)b.z();
        return dest;
    }

    public Vector3d mul(Vector3dc v) {
        return this.mul(v, this.thisOrNew());
    }

    public Vector3d mul(Vector3fc v) {
        return this.mul(v, this.thisOrNew());
    }

    public Vector3d mul(Vector3fc v, Vector3d dest) {
        dest.x = this.x * (double)v.x();
        dest.y = this.y * (double)v.y();
        dest.z = this.z * (double)v.z();
        return dest;
    }

    public Vector3d mul(Vector3dc v, Vector3d dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        return dest;
    }

    public Vector3d div(Vector3d v) {
        return this.div(v, this.thisOrNew());
    }

    public Vector3d div(Vector3fc v) {
        return this.div(v, this.thisOrNew());
    }

    public Vector3d div(Vector3fc v, Vector3d dest) {
        dest.x = this.x / (double)v.x();
        dest.y = this.y / (double)v.y();
        dest.z = this.z / (double)v.z();
        return dest;
    }

    public Vector3d div(Vector3dc v, Vector3d dest) {
        dest.x = this.x / v.x();
        dest.y = this.y / v.y();
        dest.z = this.z / v.z();
        return dest;
    }

    public Vector3d mulProject(Matrix4dc mat, Vector3d dest) {
        double invW = 1.0 / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33());
        double rx = (mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30()) * invW;
        double ry = (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31()) * invW;
        double rz = (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32()) * invW;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulProject(Matrix4dc mat) {
        return this.mulProject(mat, this.thisOrNew());
    }

    public Vector3d mulProject(Matrix4fc mat, Vector3d dest) {
        double invW = 1.0 / ((double)mat.m03() * this.x + (double)mat.m13() * this.y + (double)mat.m23() * this.z + (double)mat.m33());
        double rx = ((double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30()) * invW;
        double ry = ((double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31()) * invW;
        double rz = ((double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32()) * invW;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulProject(Matrix4fc mat) {
        return this.mulProject(mat, this.thisOrNew());
    }

    public Vector3d mul(Matrix3fc mat) {
        return this.mul(mat, this.thisOrNew());
    }

    public Vector3d mul(Matrix3dc mat) {
        return this.mul(mat, this.thisOrNew());
    }

    public Vector3d mul(Matrix3dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z;
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z;
        double rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3f mul(Matrix3dc mat, Vector3f dest) {
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z;
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z;
        double rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z;
        dest.x = (float)rx;
        dest.y = (float)ry;
        dest.z = (float)rz;
        return dest;
    }

    public Vector3d mul(Matrix3fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z;
        double ry = (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z;
        double rz = (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mul(Matrix3x2dc mat) {
        return this.mul(mat, this.thisOrNew());
    }

    public Vector3d mul(Matrix3x2dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z;
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = this.z;
        return dest;
    }

    public Vector3d mul(Matrix3x2fc mat) {
        return this.mul(mat, this.thisOrNew());
    }

    public Vector3d mul(Matrix3x2fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z;
        double ry = (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = this.z;
        return dest;
    }

    public Vector3d mulTranspose(Matrix3dc mat) {
        return this.mulTranspose(mat, this.thisOrNew());
    }

    public Vector3d mulTranspose(Matrix3dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z;
        double ry = mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z;
        double rz = mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulTranspose(Matrix3fc mat) {
        return this.mulTranspose(mat, this.thisOrNew());
    }

    public Vector3d mulTranspose(Matrix3fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m01() * this.y + (double)mat.m02() * this.z;
        double ry = (double)mat.m10() * this.x + (double)mat.m11() * this.y + (double)mat.m12() * this.z;
        double rz = (double)mat.m20() * this.x + (double)mat.m21() * this.y + (double)mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulPosition(Matrix4fc mat) {
        return this.mulPosition(mat, this.thisOrNew());
    }

    public Vector3d mulPosition(Matrix4dc mat) {
        return this.mulPosition(mat, this.thisOrNew());
    }

    public Vector3d mulPosition(Matrix4x3dc mat) {
        return this.mulPosition(mat, this.thisOrNew());
    }

    public Vector3d mulPosition(Matrix4x3fc mat) {
        return this.mulPosition(mat, this.thisOrNew());
    }

    public Vector3d mulPosition(Matrix4dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30();
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31();
        double rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulPosition(Matrix4fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30();
        double ry = (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31();
        double rz = (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulPosition(Matrix4x3dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30();
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31();
        double rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulPosition(Matrix4x3fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30();
        double ry = (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31();
        double rz = (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulTransposePosition(Matrix4dc mat) {
        return this.mulTransposePosition(mat, this.thisOrNew());
    }

    public Vector3d mulTransposePosition(Matrix4dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z + mat.m03();
        double ry = mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z + mat.m13();
        double rz = mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z + mat.m23();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulTransposePosition(Matrix4fc mat) {
        return this.mulTransposePosition(mat, this.thisOrNew());
    }

    public Vector3d mulTransposePosition(Matrix4fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m01() * this.y + (double)mat.m02() * this.z + (double)mat.m03();
        double ry = (double)mat.m10() * this.x + (double)mat.m11() * this.y + (double)mat.m12() * this.z + (double)mat.m13();
        double rz = (double)mat.m20() * this.x + (double)mat.m21() * this.y + (double)mat.m22() * this.z + (double)mat.m23();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public double mulPositionW(Matrix4fc mat) {
        return this.mulPositionW(mat, this.thisOrNew());
    }

    public double mulPositionW(Matrix4fc mat, Vector3d dest) {
        double w = (double)mat.m03() * this.x + (double)mat.m13() * this.y + (double)mat.m23() * this.z + (double)mat.m33();
        double rx = (double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z + (double)mat.m30();
        double ry = (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z + (double)mat.m31();
        double rz = (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z + (double)mat.m32();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return w;
    }

    public double mulPositionW(Matrix4dc mat) {
        return this.mulPositionW(mat, this.thisOrNew());
    }

    public double mulPositionW(Matrix4dc mat, Vector3d dest) {
        double w = mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33();
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30();
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31();
        double rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return w;
    }

    public Vector3d mulDirection(Matrix4fc mat) {
        return this.mulDirection(mat, this.thisOrNew());
    }

    public Vector3d mulDirection(Matrix4dc mat) {
        return this.mulDirection(mat, this.thisOrNew());
    }

    public Vector3d mulDirection(Matrix4x3dc mat) {
        return this.mulDirection(mat, this.thisOrNew());
    }

    public Vector3d mulDirection(Matrix4x3fc mat) {
        return this.mulDirection(mat, this.thisOrNew());
    }

    public Vector3d mulDirection(Matrix4dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z;
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z;
        double rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulDirection(Matrix4fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z;
        double ry = (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z;
        double rz = (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulDirection(Matrix4x3dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z;
        double ry = mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z;
        double rz = mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulDirection(Matrix4x3fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m10() * this.y + (double)mat.m20() * this.z;
        double ry = (double)mat.m01() * this.x + (double)mat.m11() * this.y + (double)mat.m21() * this.z;
        double rz = (double)mat.m02() * this.x + (double)mat.m12() * this.y + (double)mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulTransposeDirection(Matrix4dc mat) {
        return this.mulTransposeDirection(mat, this.thisOrNew());
    }

    public Vector3d mulTransposeDirection(Matrix4dc mat, Vector3d dest) {
        double rx = mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z;
        double ry = mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z;
        double rz = mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mulTransposeDirection(Matrix4fc mat) {
        return this.mulTransposeDirection(mat, this.thisOrNew());
    }

    public Vector3d mulTransposeDirection(Matrix4fc mat, Vector3d dest) {
        double rx = (double)mat.m00() * this.x + (double)mat.m01() * this.y + (double)mat.m02() * this.z;
        double ry = (double)mat.m10() * this.x + (double)mat.m11() * this.y + (double)mat.m12() * this.z;
        double rz = (double)mat.m20() * this.x + (double)mat.m21() * this.y + (double)mat.m22() * this.z;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d mul(double scalar) {
        return this.mul(scalar, this.thisOrNew());
    }

    public Vector3d mul(double scalar, Vector3d dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        return dest;
    }

    public Vector3d mul(double x, double y, double z) {
        return this.mul(x, y, z, this.thisOrNew());
    }

    public Vector3d mul(double x, double y, double z, Vector3d dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        return dest;
    }

    public Vector3d rotate(Quaterniondc quat) {
        return quat.transform(this, this.thisOrNew());
    }

    public Vector3d rotate(Quaterniondc quat, Vector3d dest) {
        return quat.transform(this, dest);
    }

    public Quaterniond rotationTo(Vector3dc toDir, Quaterniond dest) {
        return dest.rotationTo(this, toDir);
    }

    public Quaterniond rotationTo(double toDirX, double toDirY, double toDirZ, Quaterniond dest) {
        return dest.rotationTo(this.x, this.y, this.z, toDirX, toDirY, toDirZ);
    }

    public Vector3d rotateAxis(double angle, double x, double y, double z) {
        return this.rotateAxis(angle, x, y, z, this.thisOrNew());
    }

    public Vector3d rotateAxis(double angle, double aX, double aY, double aZ, Vector3d dest) {
        if (aY == 0.0 && aZ == 0.0 && Math.abs(aX) == 1.0) {
            return this.rotateX(aX * angle, dest);
        }
        if (aX == 0.0 && aZ == 0.0 && Math.abs(aY) == 1.0) {
            return this.rotateY(aY * angle, dest);
        }
        if (aX == 0.0 && aY == 0.0 && Math.abs(aZ) == 1.0) {
            return this.rotateZ(aZ * angle, dest);
        }
        return this.rotateAxisInternal(angle, aX, aY, aZ, dest);
    }

    private Vector3d rotateAxisInternal(double angle, double aX, double aY, double aZ, Vector3d dest) {
        double hangle = angle * 0.5;
        double sinAngle = Math.sin(hangle);
        double qx = aX * sinAngle;
        double qy = aY * sinAngle;
        double qz = aZ * sinAngle;
        double qw = Math.cosFromSin(sinAngle, hangle);
        double w2 = qw * qw;
        double x2 = qx * qx;
        double y2 = qy * qy;
        double z2 = qz * qz;
        double zw = qz * qw;
        double xy = qx * qy;
        double xz = qx * qz;
        double yw = qy * qw;
        double yz = qy * qz;
        double xw = qx * qw;
        double nx = (w2 + x2 - z2 - y2) * this.x + (-zw + xy - zw + xy) * this.y + (yw + xz + xz + yw) * this.z;
        double ny = (xy + zw + zw + xy) * this.x + (y2 - z2 + w2 - x2) * this.y + (yz + yz - xw - xw) * this.z;
        double nz = (xz - yw + xz - yw) * this.x + (yz + yz + xw + xw) * this.y + (z2 - y2 - x2 + w2) * this.z;
        dest.x = nx;
        dest.y = ny;
        dest.z = nz;
        return dest;
    }

    public Vector3d rotateX(double angle) {
        return this.rotateX(angle, this.thisOrNew());
    }

    public Vector3d rotateX(double angle, Vector3d dest) {
        double sin = Math.sin(angle);
        double cos = Math.cosFromSin(sin, angle);
        double y = this.y * cos - this.z * sin;
        double z = this.y * sin + this.z * cos;
        dest.x = this.x;
        dest.y = y;
        dest.z = z;
        return dest;
    }

    public Vector3d rotateY(double angle) {
        return this.rotateY(angle, this.thisOrNew());
    }

    public Vector3d rotateY(double angle, Vector3d dest) {
        double sin = Math.sin(angle);
        double cos = Math.cosFromSin(sin, angle);
        double x = this.x * cos + this.z * sin;
        double z = -this.x * sin + this.z * cos;
        dest.x = x;
        dest.y = this.y;
        dest.z = z;
        return dest;
    }

    public Vector3d rotateZ(double angle) {
        return this.rotateZ(angle, this.thisOrNew());
    }

    public Vector3d rotateZ(double angle, Vector3d dest) {
        double sin = Math.sin(angle);
        double cos = Math.cosFromSin(sin, angle);
        double x = this.x * cos - this.y * sin;
        double y = this.x * sin + this.y * cos;
        dest.x = x;
        dest.y = y;
        dest.z = this.z;
        return dest;
    }

    public Vector3d div(double scalar) {
        return this.div(scalar, this.thisOrNew());
    }

    public Vector3d div(double scalar, Vector3d dest) {
        double inv = 1.0 / scalar;
        dest.x = this.x * inv;
        dest.y = this.y * inv;
        dest.z = this.z * inv;
        return dest;
    }

    public Vector3d div(double x, double y, double z) {
        return this.div(x, y, z, this.thisOrNew());
    }

    public Vector3d div(double x, double y, double z, Vector3d dest) {
        dest.x = this.x / x;
        dest.y = this.y / y;
        dest.z = this.z / z;
        return dest;
    }

    public double lengthSquared() {
        return Vector3d.lengthSquared(this.x, this.y, this.z);
    }

    public static double lengthSquared(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt(Vector3d.lengthSquared(x, y, z));
    }

    public Vector3d normalize() {
        return this.normalize(this.thisOrNew());
    }

    public Vector3d normalize(Vector3d dest) {
        double invLength = 1.0 / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        return dest;
    }

    public Vector3d normalize(double length) {
        return this.normalize(length, this.thisOrNew());
    }

    public Vector3d normalize(double length, Vector3d dest) {
        double invLength = 1.0 / this.length() * length;
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        return dest;
    }

    public Vector3d cross(Vector3dc v) {
        return this.cross(v, this.thisOrNew());
    }

    public Vector3d cross(double x, double y, double z) {
        return this.cross(x, y, z, this.thisOrNew());
    }

    public Vector3d cross(Vector3dc v, Vector3d dest) {
        double rx = this.y * v.z() - this.z * v.y();
        double ry = this.z * v.x() - this.x * v.z();
        double rz = this.x * v.y() - this.y * v.x();
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public Vector3d cross(double x, double y, double z, Vector3d dest) {
        double rx = this.y * z - this.z * y;
        double ry = this.z * x - this.x * z;
        double rz = this.x * y - this.y * x;
        dest.x = rx;
        dest.y = ry;
        dest.z = rz;
        return dest;
    }

    public double distance(Vector3dc v) {
        return this.distance(v.x(), v.y(), v.z());
    }

    public double distance(double x, double y, double z) {
        return Math.sqrt(this.distanceSquared(x, y, z));
    }

    public double distanceSquared(Vector3dc v) {
        return this.distanceSquared(v.x(), v.y(), v.z());
    }

    public double distanceSquared(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Vector3d.distanceSquared(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public double dot(Vector3dc v) {
        return this.dot(v.x(), v.y(), v.z());
    }

    public double dot(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public double angleCos(Vector3dc v) {
        double length1Squared = this.x * this.x + this.y * this.y + this.z * this.z;
        double length2Squared = v.x() * v.x() + v.y() * v.y() + v.z() * v.z();
        double dot = this.x * v.x() + this.y * v.y() + this.z * v.z();
        return dot / Math.sqrt(length1Squared * length2Squared);
    }

    public double angle(Vector3dc v) {
        double cos = this.angleCos(v);
        cos = cos < 1.0 ? cos : 1.0;
        cos = cos > -1.0 ? cos : -1.0;
        return Math.acos(cos);
    }

    public double angleSigned(Vector3dc v, Vector3dc n) {
        return this.angleSigned(v.x(), v.y(), v.z(), n.x(), n.y(), n.z());
    }

    public double angleSigned(double x, double y, double z, double nx, double ny, double nz) {
        return Math.atan2((this.y * z - this.z * y) * nx + (this.z * x - this.x * z) * ny + (this.x * y - this.y * x) * nz, this.x * x + this.y * y + this.z * z);
    }

    public Vector3d min(Vector3dc v) {
        return this.min(v, this.thisOrNew());
    }

    public Vector3d min(Vector3dc v, Vector3d dest) {
        dest.x = this.x < v.x() ? this.x : v.x();
        dest.y = this.y < v.y() ? this.y : v.y();
        dest.z = this.z < v.z() ? this.z : v.z();
        return dest;
    }

    public Vector3d max(Vector3dc v) {
        return this.max(v, this.thisOrNew());
    }

    public Vector3d max(Vector3dc v, Vector3d dest) {
        dest.x = this.x > v.x() ? this.x : v.x();
        dest.y = this.y > v.y() ? this.y : v.y();
        dest.z = this.z > v.z() ? this.z : v.z();
        return dest;
    }

    public Vector3d zero() {
        return this.thisOrNew().set(0.0, 0.0, 0.0);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    public Vector3d negate() {
        return this.negate(this.thisOrNew());
    }

    public Vector3d negate(Vector3d dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public Vector3d absolute() {
        return this.absolute(this.thisOrNew());
    }

    public Vector3d absolute(Vector3d dest) {
        dest.x = Math.abs(this.x);
        dest.y = Math.abs(this.y);
        dest.z = Math.abs(this.z);
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3d other = (Vector3d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public boolean equals(Vector3dc v, double delta) {
        if (this == v) {
            return true;
        }
        if (v == null) {
            return false;
        }
        if (!(v instanceof Vector3dc)) {
            return false;
        }
        if (!Runtime.equals(this.x, v.x(), delta)) {
            return false;
        }
        if (!Runtime.equals(this.y, v.y(), delta)) {
            return false;
        }
        return Runtime.equals(this.z, v.z(), delta);
    }

    public boolean equals(double x, double y, double z) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(z);
    }

    public Vector3d reflect(Vector3dc normal) {
        return this.reflect(normal, this.thisOrNew());
    }

    public Vector3d reflect(double x, double y, double z) {
        return this.reflect(x, y, z, this.thisOrNew());
    }

    public Vector3d reflect(Vector3dc normal, Vector3d dest) {
        return this.reflect(normal.x(), normal.y(), normal.z(), dest);
    }

    public Vector3d reflect(double x, double y, double z, Vector3d dest) {
        double dot = this.dot(x, y, z);
        dest.x = this.x - (dot + dot) * x;
        dest.y = this.y - (dot + dot) * y;
        dest.z = this.z - (dot + dot) * z;
        return dest;
    }

    public Vector3d half(Vector3dc other) {
        return this.half(other, this.thisOrNew());
    }

    public Vector3d half(double x, double y, double z) {
        return this.half(x, y, z, this.thisOrNew());
    }

    public Vector3d half(Vector3dc other, Vector3d dest) {
        return this.half(other.x(), other.y(), other.z(), dest);
    }

    public Vector3d half(double x, double y, double z, Vector3d dest) {
        return dest.set(this).add(x, y, z).normalize();
    }

    public Vector3d smoothStep(Vector3dc v, double t, Vector3d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v.x() - v.x()) * t3 + (3.0 * v.x() - 3.0 * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y() - v.y()) * t3 + (3.0 * v.y() - 3.0 * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z() - v.z()) * t3 + (3.0 * v.z() - 3.0 * this.z) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3d hermite(Vector3dc t0, Vector3dc v1, Vector3dc t1, double t, Vector3d dest) {
        double t2 = t * t;
        double t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x() - v1.x() + t1.x() + t0.x()) * t3 + (3.0 * v1.x() - 3.0 * this.x - t0.x() - t0.x() - t1.x()) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y() - v1.y() + t1.y() + t0.y()) * t3 + (3.0 * v1.y() - 3.0 * this.y - t0.y() - t0.y() - t1.y()) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z() - v1.z() + t1.z() + t0.z()) * t3 + (3.0 * v1.z() - 3.0 * this.z - t0.z() - t0.z() - t1.z()) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3d lerp(Vector3dc other, double t) {
        return this.lerp(other, t, this.thisOrNew());
    }

    public Vector3d lerp(Vector3dc other, double t, Vector3d dest) {
        dest.x = this.x + (other.x() - this.x) * t;
        dest.y = this.y + (other.y() - this.y) * t;
        dest.z = this.z + (other.z() - this.z) * t;
        return dest;
    }

    public double get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public int maxComponent() {
        double absX = Math.abs(this.x);
        double absY = Math.abs(this.y);
        double absZ = Math.abs(this.z);
        if (absX >= absY && absX >= absZ) {
            return 0;
        }
        if (absY >= absZ) {
            return 1;
        }
        return 2;
    }

    public int minComponent() {
        double absX = Math.abs(this.x);
        double absY = Math.abs(this.y);
        double absZ = Math.abs(this.z);
        if (absX < absY && absX < absZ) {
            return 0;
        }
        if (absY < absZ) {
            return 1;
        }
        return 2;
    }

    public Vector3d orthogonalize(Vector3dc v, Vector3d dest) {
        double rz;
        double ry;
        double rx;
        if (Math.abs(v.x()) > Math.abs(v.z())) {
            rx = -v.y();
            ry = v.x();
            rz = 0.0;
        } else {
            rx = 0.0;
            ry = -v.z();
            rz = v.y();
        }
        double invLen = 1.0 / Math.sqrt(rx * rx + ry * ry + rz * rz);
        dest.x = rx * invLen;
        dest.y = ry * invLen;
        dest.z = rz * invLen;
        return dest;
    }

    public Vector3d orthogonalize(Vector3dc v) {
        return this.orthogonalize(v, this.thisOrNew());
    }

    public Vector3d orthogonalizeUnit(Vector3dc v, Vector3d dest) {
        return this.orthogonalize(v, dest);
    }

    public Vector3d orthogonalizeUnit(Vector3dc v) {
        return this.orthogonalizeUnit(v, this.thisOrNew());
    }

    public Vector3d floor() {
        return this.floor(this.thisOrNew());
    }

    public Vector3d floor(Vector3d dest) {
        dest.x = Math.floor(this.x);
        dest.y = Math.floor(this.y);
        dest.z = Math.floor(this.z);
        return dest;
    }

    public Vector3d ceil() {
        return this.ceil(this.thisOrNew());
    }

    public Vector3d ceil(Vector3d dest) {
        dest.x = Math.ceil(this.x);
        dest.y = Math.ceil(this.y);
        dest.z = Math.ceil(this.z);
        return dest;
    }

    public Vector3d round() {
        return this.round(this.thisOrNew());
    }

    public Vector3d round(Vector3d dest) {
        dest.x = Math.round(this.x);
        dest.y = Math.round(this.y);
        dest.z = Math.round(this.z);
        return dest;
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z);
    }
}

