/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.HttpParserKt;
import io.ktor.http.cio.ParserException;
import io.ktor.http.cio.Request;
import io.ktor.http.cio.Response;
import io.ktor.http.cio.internals.AsciiCharTree;
import io.ktor.http.cio.internals.CharArrayBuilder;
import io.ktor.http.cio.internals.CharsKt;
import io.ktor.http.cio.internals.MutableRange;
import io.ktor.http.cio.internals.TokenizerKt;
import io.ktor.utils.io.ByteReadChannel;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a(\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!\u001a-\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#\u001a\u0018\u0010$\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010&\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001f\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!\u001a\u001b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u001f\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!\u001a\u0018\u0010+\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"HTTP_LINE_LIMIT", "", "HTTP_STATUS_CODE_MAX_RANGE", "HTTP_STATUS_CODE_MIN_RANGE", "hostForbiddenSymbols", "", "", "versions", "Lio/ktor/http/cio/internals/AsciiCharTree;", "", "getVersions$annotations", "()V", "characterIsNotAllowed", "", "text", "", "ch", "isDelimiter", "", "noColonFound", "range", "Lio/ktor/http/cio/internals/MutableRange;", "parseHeaderName", "Lio/ktor/http/cio/internals/CharArrayBuilder;", "parseHeaderNameFailed", "index", "start", "parseHeaderValue", "", "parseHeaders", "Lio/ktor/http/cio/HttpHeadersMap;", "input", "Lio/ktor/utils/io/ByteReadChannel;", "(Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "builder", "(Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/http/cio/internals/CharArrayBuilder;Lio/ktor/http/cio/internals/MutableRange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseHttpMethod", "Lio/ktor/http/HttpMethod;", "parseHttpMethodFull", "parseRequest", "Lio/ktor/http/cio/Request;", "parseResponse", "Lio/ktor/http/cio/Response;", "parseStatusCode", "parseUri", "parseVersion", "statusOutOfRange", "code", "ktor-http-cio"})
public final class HttpParserKt {
    private static final int HTTP_LINE_LIMIT = 8192;
    private static final int HTTP_STATUS_CODE_MIN_RANGE = 100;
    private static final int HTTP_STATUS_CODE_MAX_RANGE = 999;
    @NotNull
    private static final Set<Character> hostForbiddenSymbols;
    @NotNull
    private static final AsciiCharTree<String> versions;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static final Object parseRequest(@NotNull ByteReadChannel var0, @NotNull Continuation<? super Request> var1_1) {
        if (!(var1_1 instanceof parseRequest.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpParserKt.parseRequest(null, (Continuation<? super Request>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                builder = new CharArrayBuilder(null, 1, null);
                range = new MutableRange(0, 0);
                try {
                }
                catch (Throwable t) {
                    builder.release();
                    throw t;
                }
                while (true) {
                    $continuation.L$0 = input;
                    $continuation.L$1 = builder;
                    $continuation.L$2 = range;
                    $continuation.label = 1;
                    v0 = input.readUTF8LineTo((Appendable)builder, 8192, (Continuation)$continuation);
                    if (v0 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl37
                    break;
                }
            }
            case 1: {
                range = (MutableRange)$continuation.L$2;
                builder = (CharArrayBuilder)$continuation.L$1;
                input = (ByteReadChannel)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl37:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) {
                        return null;
                    }
                    range.setEnd(builder.length());
                    if (range.getStart() == range.getEnd()) ** continue;
                    method = HttpParserKt.parseHttpMethod(builder, range);
                    uri = HttpParserKt.parseUri(builder, range);
                    version = HttpParserKt.parseVersion(builder, range);
                    TokenizerKt.skipSpaces(builder, range);
                    if (range.getStart() != range.getEnd()) {
                        throw new ParserException(Intrinsics.stringPlus((String)"Extra characters in request line: ", (Object)((CharSequence)builder).subSequence(range.getStart(), range.getEnd()).toString()));
                    }
                    if (uri.length() == 0) {
                        throw new ParserException("URI is not specified");
                    }
                    if (version.length() == 0) {
                        throw new ParserException("HTTP version is not specified");
                    }
                    $continuation.L$0 = builder;
                    $continuation.L$1 = method;
                    $continuation.L$2 = uri;
                    $continuation.L$3 = version;
                    $continuation.label = 2;
                    v1 = HttpParserKt.parseHeaders(input, builder, range, (Continuation<? super HttpHeadersMap>)$continuation);
                    ** if (v1 != var10_4) goto lbl59
                }
lbl58:
                // 1 sources

                return var10_4;
lbl59:
                // 1 sources

                ** GOTO lbl68
            }
            case 2: {
                version = (CharSequence)$continuation.L$3;
                uri = (CharSequence)$continuation.L$2;
                method = (HttpMethod)$continuation.L$1;
                builder = (CharArrayBuilder)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl68:
                    // 2 sources

                    v2 = (HttpHeadersMap)v1;
                    if (v2 == null) {
                        return null;
                    }
                    headers = v2;
                    return new Request(method, uri, version, headers, builder);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object parseResponse(@NotNull ByteReadChannel var0, @NotNull Continuation<? super Response> var1_1) {
        if (!(var1_1 instanceof parseResponse.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpParserKt.parseResponse(null, (Continuation<? super Response>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                builder = new CharArrayBuilder(null, 1, null);
                range = new MutableRange(0, 0);
                $continuation.L$0 = input;
                $continuation.L$1 = builder;
                $continuation.L$2 = range;
                $continuation.label = 1;
                v0 = input.readUTF8LineTo((Appendable)builder, 8192, (Continuation)$continuation);
                ** if (v0 != var10_4) goto lbl23
lbl22:
                // 1 sources

                return var10_4;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                range = (MutableRange)$continuation.L$2;
                builder = (CharArrayBuilder)$continuation.L$1;
                input = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    return null;
                }
                range.setEnd(builder.length());
                version = HttpParserKt.parseVersion(builder, range);
                statusCode = HttpParserKt.parseStatusCode(builder, range);
                TokenizerKt.skipSpaces(builder, range);
                statusText = builder.subSequence(range.getStart(), range.getEnd());
                range.setStart(range.getEnd());
                $continuation.L$0 = builder;
                $continuation.L$1 = version;
                $continuation.L$2 = statusText;
                $continuation.I$0 = statusCode;
                $continuation.label = 2;
                v1 = HttpParserKt.parseHeaders(input, builder, range, (Continuation<? super HttpHeadersMap>)$continuation);
                ** if (v1 != var10_4) goto lbl48
lbl47:
                // 1 sources

                return var10_4;
lbl48:
                // 1 sources

                ** GOTO lbl58
            }
            case 2: {
                statusCode = $continuation.I$0;
                statusText = (CharSequence)$continuation.L$2;
                version = (CharSequence)$continuation.L$1;
                builder = (CharArrayBuilder)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl58:
                    // 2 sources

                    if ((v2 = (HttpHeadersMap)v1) == null) {
                        v2 = new HttpHeadersMap(builder);
                    }
                    headers = v2;
                    return new Response(version, statusCode, statusText, headers, builder);
                }
                catch (Throwable t) {
                    builder.release();
                    throw t;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object parseHeaders(@NotNull ByteReadChannel var0, @NotNull Continuation<? super HttpHeadersMap> var1_1) {
        if (!(var1_1 instanceof parseHeaders.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpParserKt.parseHeaders(null, (Continuation<? super HttpHeadersMap>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                builder = new CharArrayBuilder(null, 1, null);
                $continuation.L$0 = builder;
                $continuation.label = 1;
                v0 = HttpParserKt.parseHeaders$default(input, builder, null, (Continuation)$continuation, 4, null);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                builder = (CharArrayBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if ((v1 = (HttpHeadersMap)v0) == null) {
                    v1 = new HttpHeadersMap(builder);
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static final Object parseHeaders(@NotNull ByteReadChannel var0, @NotNull CharArrayBuilder var1_1, @NotNull MutableRange var2_2, @NotNull Continuation<? super HttpHeadersMap> var3_3) {
        if (!(var3_3 instanceof parseHeaders.2)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpParserKt.parseHeaders(null, null, null, (Continuation<? super HttpHeadersMap>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                headers = new HttpHeadersMap(builder);
                try {
                }
                catch (Throwable t) {
                    headers.release();
                    throw t;
                }
lbl20:
                // 2 sources

                while (true) {
                    $continuation.L$0 = input;
                    $continuation.L$1 = builder;
                    $continuation.L$2 = range;
                    $continuation.L$3 = headers;
                    $continuation.label = 1;
                    v0 = input.readUTF8LineTo((Appendable)builder, 8192, (Continuation)$continuation);
                    if (v0 == var15_6) {
                        return var15_6;
                    }
                    ** GOTO lbl38
                    break;
                }
            }
            case 1: {
                headers = (HttpHeadersMap)$continuation.L$3;
                range = (MutableRange)$continuation.L$2;
                builder = (CharArrayBuilder)$continuation.L$1;
                input = (ByteReadChannel)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) {
                        headers.release();
                        return null;
                    }
                    range.setEnd(builder.length());
                    rangeLength = range.getEnd() - range.getStart();
                    if (rangeLength != 0) ** GOTO lbl47
                    host = headers.get(HttpHeaders.INSTANCE.getHost());
                    if (host == null) ** GOTO lbl75
                    ** GOTO lbl61
lbl47:
                    // 1 sources

                    if (rangeLength >= 8192) {
                        var6_12 = "Header line length limit exceeded";
                        throw new IllegalStateException(var6_12.toString());
                    }
                    nameStart = range.getStart();
                    nameEnd = HttpParserKt.parseHeaderName(builder, range);
                    nameHash = CharsKt.hashCodeLowerCase(builder, nameStart, nameEnd);
                    headerEnd = range.getEnd();
                    HttpParserKt.parseHeaderValue(builder, range);
                    valueStart = range.getStart();
                    valueEnd = range.getEnd();
                    valueHash = CharsKt.hashCodeLowerCase(builder, valueStart, valueEnd);
                    range.setStart(headerEnd);
                    headers.put(nameHash, valueHash, nameStart, nameEnd, valueStart, valueEnd);
                    ** continue;
lbl61:
                    // 1 sources

                    $this$any$iv = host;
                    $i$f$any = false;
                    var8_16 = $this$any$iv;
                    for (var9_17 = 0; var9_17 < var8_16.length(); ++var9_17) {
                        element$iv = var8_16.charAt(var9_17);
                        it = element$iv;
                        $i$a$-any-HttpParserKt$parseHeaders$3 = false;
                        if (!HttpParserKt.hostForbiddenSymbols.contains(Boxing.boxChar((char)it))) continue;
                        v1 = true;
                        ** GOTO lbl72
                    }
                    v1 = false;
lbl72:
                    // 2 sources

                    if (v1) {
                        var6_13 = Intrinsics.stringPlus((String)"Host cannot contain any of the following symbols: ", HttpParserKt.hostForbiddenSymbols);
                        throw new IllegalStateException(var6_13.toString());
                    }
lbl75:
                    // 3 sources

                    return headers;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object parseHeaders$default(ByteReadChannel byteReadChannel, CharArrayBuilder charArrayBuilder, MutableRange mutableRange, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            mutableRange = new MutableRange(0, 0);
        }
        return HttpParserKt.parseHeaders(byteReadChannel, charArrayBuilder, mutableRange, (Continuation<? super HttpHeadersMap>)continuation);
    }

    private static final HttpMethod parseHttpMethod(CharSequence text, MutableRange range) {
        TokenizerKt.skipSpaces(text, range);
        HttpMethod exact2 = (HttpMethod)CollectionsKt.singleOrNull((List)AsciiCharTree.search$default(CharsKt.getDefaultHttpMethods(), text, range.getStart(), range.getEnd(), false, parseHttpMethod.exact.1.INSTANCE, 8, null));
        if (exact2 != null) {
            range.setStart(range.getStart() + exact2.getValue().length());
            return exact2;
        }
        return HttpParserKt.parseHttpMethodFull(text, range);
    }

    private static final HttpMethod parseHttpMethodFull(CharSequence text, MutableRange range) {
        return new HttpMethod(((Object)TokenizerKt.nextToken(text, range)).toString());
    }

    private static final CharSequence parseUri(CharSequence text, MutableRange range) {
        TokenizerKt.skipSpaces(text, range);
        int start2 = range.getStart();
        int spaceOrEnd = TokenizerKt.findSpaceOrEnd(text, range);
        int length = spaceOrEnd - start2;
        if (length <= 0) {
            return "";
        }
        if (length == 1 && text.charAt(start2) == '/') {
            range.setStart(spaceOrEnd);
            return "/";
        }
        CharSequence s = text.subSequence(start2, spaceOrEnd);
        range.setStart(spaceOrEnd);
        return s;
    }

    private static /* synthetic */ void getVersions$annotations() {
    }

    private static final CharSequence parseVersion(CharSequence text, MutableRange range) {
        TokenizerKt.skipSpaces(text, range);
        if (!(range.getStart() < range.getEnd())) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Failed to parse version: ", (Object)text);
            throw new IllegalStateException(string.toString());
        }
        String exact2 = (String)CollectionsKt.singleOrNull((List)AsciiCharTree.search$default(versions, text, range.getStart(), range.getEnd(), false, parseVersion.exact.1.INSTANCE, 8, null));
        if (exact2 != null) {
            range.setStart(range.getStart() + exact2.length());
            return exact2;
        }
        return TokenizerKt.nextToken(text, range);
    }

    private static final int parseStatusCode(CharSequence text, MutableRange range) {
        TokenizerKt.skipSpaces(text, range);
        int status = 0;
        int newStart = range.getEnd();
        int n = range.getStart();
        int n2 = range.getEnd();
        while (n < n2) {
            int idx;
            char ch;
            if ((ch = text.charAt(idx = n++)) == ' ') {
                if (HttpParserKt.statusOutOfRange(status)) {
                    throw new ParserException("Status-code must be 3-digit. Status received: " + status + '.');
                }
                newStart = idx;
                break;
            }
            boolean bl = '0' <= ch ? ch < ':' : false;
            if (bl) {
                status = status * 10 + (ch - 48);
                continue;
            }
            String code = ((Object)text.subSequence(range.getStart(), TokenizerKt.findSpaceOrEnd(text, range))).toString();
            throw new NumberFormatException("Illegal digit " + ch + " in status code " + code);
        }
        range.setStart(newStart);
        return status;
    }

    private static final boolean statusOutOfRange(int code) {
        return code < 100 || code > 999;
    }

    public static final int parseHeaderName(@NotNull CharArrayBuilder text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int index = range.getStart();
        int end = range.getEnd();
        while (index < end) {
            char ch = text.charAt(index);
            if (ch == ':' && index != range.getStart()) {
                range.setStart(index + 1);
                return index;
            }
            if (HttpParserKt.isDelimiter(ch)) {
                HttpParserKt.parseHeaderNameFailed(text, index, range.getStart(), ch);
                throw new KotlinNothingValueException();
            }
            int n = index;
            index = n + 1;
        }
        HttpParserKt.noColonFound(text, range);
        throw new KotlinNothingValueException();
    }

    private static final Void parseHeaderNameFailed(CharArrayBuilder text, int index, int start2, char ch) {
        if (ch == ':') {
            throw new ParserException("Empty header names are not allowed as per RFC7230.");
        }
        if (index == start2) {
            throw new ParserException("Multiline headers via line folding is not supported since it is deprecated as per RFC7230.");
        }
        HttpParserKt.characterIsNotAllowed(text, ch);
        throw new KotlinNothingValueException();
    }

    public static final void parseHeaderValue(@NotNull CharArrayBuilder text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int start2 = range.getStart();
        int end = range.getEnd();
        int index = start2;
        index = TokenizerKt.skipSpacesAndHorizontalTabs(text, index, end);
        if (index >= end) {
            range.setStart(end);
            return;
        }
        int valueStart = index;
        int valueLastIndex = index;
        while (index < end) {
            int ch = text.charAt(index);
            int n = ch;
            if (!(n == 9 ? true : n == 32)) {
                if (n == 13 ? true : n == 10) {
                    HttpParserKt.characterIsNotAllowed(text, (char)ch);
                    throw new KotlinNothingValueException();
                }
                valueLastIndex = index;
            }
            n = index;
            index = n + 1;
        }
        range.setStart(valueStart);
        range.setEnd(valueLastIndex + 1);
    }

    private static final Void noColonFound(CharSequence text, MutableRange range) {
        throw new ParserException("No colon in HTTP header in " + ((Object)text.subSequence(range.getStart(), range.getEnd())).toString() + " in builder: \n" + text);
    }

    private static final Void characterIsNotAllowed(CharSequence text, char ch) {
        throw new ParserException("Character with code " + (ch & 0xFF) + " is not allowed in header names, \n" + text);
    }

    private static final boolean isDelimiter(char ch) {
        return Intrinsics.compare((int)ch, (int)32) <= 0 || StringsKt.contains$default((CharSequence)"\"(),/:;<=>?@[\\]{}", (char)ch, (boolean)false, (int)2, null);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('@')};
        hostForbiddenSymbols = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"HTTP/1.0", "HTTP/1.1"};
        versions = AsciiCharTree.Companion.build(CollectionsKt.listOf((Object[])objectArray));
    }
}

