/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriteable;
import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterStream;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;

@Title(value="MaterializeDistances")
@Description(value="Materialize all distances in the data set to use as cached/precalculated data.")
public class MaterializeDistances<O>
extends AbstractDistanceBasedAlgorithm<O, CollectionResult<DistanceEntry>> {
    private static final Logging LOG = Logging.getLogger(MaterializeDistances.class);

    public MaterializeDistances(DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
    }

    public CollectionResult<DistanceEntry> run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        int n = relation.size();
        ArrayList<DistanceEntry> arrayList = new ArrayList<DistanceEntry>(n * (n + 1) >> 1);
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            DBIDIter dBIDIter2 = relation.iterDBIDs();
            while (dBIDIter2.valid()) {
                if (DBIDUtil.compare(dBIDIter2, dBIDIter) <= 0) {
                    double d = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDIter2);
                    arrayList.add(new DistanceEntry(DBIDUtil.newPair(dBIDIter, (DBIDRef)dBIDIter2), d));
                }
                dBIDIter2.advance();
            }
            dBIDIter.advance();
        }
        return new CollectionResult<DistanceEntry>("Distance Matrix", "distance-matrix", arrayList);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        @Override
        protected MaterializeDistances<O> makeInstance() {
            return new MaterializeDistances(this.distanceFunction);
        }
    }

    public static class DistanceEntry
    implements TextWriteable {
        DBIDPair ids;
        double distance;

        public DistanceEntry(DBIDPair dBIDPair, double d) {
            this.ids = dBIDPair;
            this.distance = d;
        }

        @Override
        public void writeToText(TextWriterStream textWriterStream, String string) {
            textWriterStream.inlinePrint(this.ids.getFirst());
            textWriterStream.inlinePrint(this.ids.getSecond());
            textWriterStream.inlinePrint(this.distance);
        }
    }
}

