/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.ArrayList;
import java.util.List;

@Reference(authors="Y. Cheng", title="Mean shift, mode seeking, and clustering", booktitle="IEEE Transactions on Pattern Analysis and Machine Intelligence 17-8", url="http://dx.doi.org/10.1109/34.400568")
public class NaiveMeanShiftClustering<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, Clustering<MeanModel>>
implements ClusteringAlgorithm<Clustering<MeanModel>> {
    private static final Logging LOG = Logging.getLogger(NaiveMeanShiftClustering.class);
    KernelDensityFunction kernel = EpanechnikovKernelDensityFunction.KERNEL;
    double bandwidth;
    static final int MAXITER = 1000;

    public NaiveMeanShiftClustering(DistanceFunction<? super V> distanceFunction, KernelDensityFunction kernelDensityFunction, double d) {
        super(distanceFunction);
        this.kernel = kernelDensityFunction;
        this.bandwidth = d;
    }

    public Clustering<MeanModel> run(Database database, Relation<V> relation) {
        Object object;
        DistanceQuery<V> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<V> rangeQuery = database.getRangeQuery(distanceQuery, new Object[0]);
        int n = RelationUtil.dimensionality(relation);
        double d = this.bandwidth * 1.0E-10;
        ArrayList<Pair<Object, ArrayModifiableDBIDs>> arrayList = new ArrayList<Pair<Object, ArrayModifiableDBIDs>>();
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Mean-shift clustering", relation.size(), LOG) : null;
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            object = (NumberVector)relation.get((DBIDRef)object2);
            for (int i = 1; i <= 1000; ++i) {
                Object object3;
                boolean bl;
                Object object4 = null;
                DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForObject(object, this.bandwidth);
                boolean bl2 = bl = doubleDBIDList.size() > 1 || doubleDBIDList.size() >= 1 && i > 1;
                if (bl) {
                    object3 = new Centroid(n);
                    DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
                    while (doubleDBIDListIter.valid()) {
                        double d2 = this.kernel.density(doubleDBIDListIter.doubleValue() / this.bandwidth);
                        ((Centroid)object3).put((NumberVector)relation.get(doubleDBIDListIter), d2);
                        doubleDBIDListIter.advance();
                    }
                    object4 = ((Centroid)object3).toVector(relation);
                }
                if (!bl) {
                    arrayModifiableDBIDs.add((DBIDRef)object2);
                    break;
                }
                double d3 = Double.POSITIVE_INFINITY;
                object3 = null;
                for (Pair pair : arrayList) {
                    double d4 = distanceQuery.distance(object4, pair.first);
                    if (!(d4 < d3)) continue;
                    d3 = d4;
                    object3 = pair;
                }
                double d5 = distanceQuery.distance(object, object4);
                if (d3 < 10.0 * d || d3 * 2.0 < d5) {
                    ((ModifiableDBIDs)((Pair)object3).second).add((DBIDRef)object2);
                    break;
                }
                if (i == 1000) {
                    LOG.warning("No convergence after 1000 iterations. Distance: " + d5);
                }
                if (Double.isNaN(d5)) {
                    LOG.warning("Encountered NaN distance. Invalid center vector? " + object4.toString());
                    break;
                }
                if (i == 1000 || d5 < d) {
                    if (LOG.isDebuggingFine()) {
                        LOG.debugFine("New cluster:" + object4 + " delta: " + d5 + " threshold: " + d + " bestd: " + d3);
                    }
                    ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray();
                    arrayModifiableDBIDs2.add((DBIDRef)object2);
                    arrayList.add(new Pair<Object, ArrayModifiableDBIDs>(object4, arrayModifiableDBIDs2));
                    break;
                }
                object = object4;
            }
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object2 = new ArrayList(arrayList.size());
        for (Pair pair : arrayList) {
            ((ArrayList)object2).add(new Cluster<MeanModel>((DBIDs)pair.second, new MeanModel(((NumberVector)pair.first).getColumnVector())));
        }
        if (arrayModifiableDBIDs.size() > 0) {
            ((ArrayList)object2).add(new Cluster((DBIDs)arrayModifiableDBIDs, true));
        }
        object = new Clustering<MeanModel>("Mean-shift Clustering", "mean-shift-clustering", (List<Cluster<MeanModel>>)object2);
        return object;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID KERNEL_ID = new OptionID("meanshift.kernel", "Kernel function to use with mean-shift clustering.");
        public static final OptionID RANGE_ID = new OptionID("meanshift.kernel-bandwidth", "Range of the kernel to use (aka: radius, bandwidth).");
        KernelDensityFunction kernel = EpanechnikovKernelDensityFunction.KERNEL;
        double range;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, EpanechnikovKernelDensityFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.kernel = (KernelDensityFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(RANGE_ID))) {
                this.range = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected NaiveMeanShiftClustering<V> makeInstance() {
            return new NaiveMeanShiftClustering(this.distanceFunction, this.kernel, this.range);
        }
    }
}

