/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.em;

import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EMClusterModel;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.EMModel;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import java.util.Arrays;

public class DiagonalGaussianModel
implements EMClusterModel<EMModel> {
    private static Logging LOG = Logging.getLogger(DiagonalGaussianModel.class);
    Vector mean;
    double[] variances;
    double[] nmea;
    double[] mref;
    double norm;
    double normDistrFactor;
    double weight;
    double wsum;

    public DiagonalGaussianModel(double d, Vector vector) {
        this(d, vector, MathUtil.powi(Math.PI * 2, vector.getDimensionality()));
    }

    public DiagonalGaussianModel(double d, Vector vector, double d2) {
        this.weight = d;
        int n = vector.getDimensionality();
        this.mean = vector;
        this.norm = d2;
        this.normDistrFactor = 1.0 / Math.sqrt(d2);
        this.mref = vector.getArrayRef();
        this.nmea = new double[n];
        this.variances = new double[n];
        Arrays.fill(this.variances, 1.0);
        this.wsum = 0.0;
    }

    @Override
    public void beginEStep() {
        this.wsum = 0.0;
    }

    @Override
    public void updateE(NumberVector numberVector, double d) {
        int n;
        assert (numberVector.getDimensionality() == this.mref.length);
        double d2 = this.wsum + d;
        for (n = 0; n < this.mref.length; ++n) {
            double d3 = numberVector.doubleValue(n) - this.mref[n];
            double d4 = d3 * d / d2;
            this.nmea[n] = this.mref[n] + d4;
        }
        for (n = 0; n < this.mref.length; ++n) {
            int n2 = n;
            this.variances[n2] = this.variances[n2] + (numberVector.doubleValue(n) - this.nmea[n]) * (numberVector.doubleValue(n) - this.mref[n]) * d;
        }
        this.wsum = d2;
        System.arraycopy(this.nmea, 0, this.mref, 0, this.nmea.length);
    }

    @Override
    public void finalizeEStep() {
        if (this.wsum > 0.0) {
            double d = 1.0 / this.wsum;
            double d2 = 1.0;
            for (int i = 0; i < this.variances.length; ++i) {
                double d3 = this.variances[i];
                this.variances[i] = d3 = d3 > 0.0 ? d3 * d : 1.0E-9;
                d2 *= d3;
            }
            this.normDistrFactor = 1.0 / Math.sqrt(this.norm * d2);
        } else {
            this.normDistrFactor = 1.0 / Math.sqrt(this.norm);
        }
    }

    public double mahalanobisDistance(Vector vector) {
        double[] dArray = vector.minus(this.mean).getArrayRef();
        double d = 0.0;
        for (int i = 0; i < this.variances.length; ++i) {
            d += dArray[i] / this.variances[i] * dArray[i];
        }
        return d;
    }

    public double mahalanobisDistance(NumberVector numberVector) {
        double[] dArray = numberVector.getColumnVector().minusEquals(this.mean).getArrayRef();
        double d = 0.0;
        for (int i = 0; i < this.variances.length; ++i) {
            d += dArray[i] / this.variances[i] * dArray[i];
        }
        return d;
    }

    @Override
    public double estimateDensity(NumberVector numberVector) {
        double d = this.mahalanobisDistance(numberVector) * 0.5;
        double d2 = this.normDistrFactor * Math.exp(-d);
        if (!(d2 >= 0.0)) {
            LOG.warning("Invalid probability: " + d2 + " power: " + d + " factor: " + this.normDistrFactor);
            d2 = 0.0;
        }
        return d2 * this.weight;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double d) {
        this.weight = d;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, Matrix.diagonal(this.variances));
    }
}

