/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.EpsilonNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.MinPtsCorePredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.AbstractModel;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.CoreObjectsModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.list.array.TIntArrayList;

@Reference(authors="J\u00f6rg Sander, Martin Ester, Hans-Peter Kriegel, Xiaowei Xu", title="Density-Based Clustering in Spatial Databases: The Algorithm GDBSCAN and Its Applications", booktitle="Data Mining and Knowledge Discovery", url="http://dx.doi.org/10.1023/A:1009745219419")
public class GeneralizedDBSCAN
extends AbstractAlgorithm<Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(GeneralizedDBSCAN.class);
    protected NeighborPredicate npred;
    protected CorePredicate corepred;
    protected boolean coremodel = false;

    public GeneralizedDBSCAN(NeighborPredicate neighborPredicate, CorePredicate corePredicate, boolean bl) {
        this.npred = neighborPredicate;
        this.corepred = corePredicate;
        this.coremodel = bl;
    }

    @Override
    public Clustering<Model> run(Database database) {
        for (SimpleTypeInformation<?> simpleTypeInformation : this.npred.getOutputType()) {
            if (!this.corepred.acceptsType(simpleTypeInformation)) continue;
            return new Instance(this.npred.instantiate(database, simpleTypeInformation), this.corepred.instantiate(database, simpleTypeInformation), this.coremodel).run();
        }
        throw new AbortException("No compatible types found.");
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.npred.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NEIGHBORHOODPRED_ID = new OptionID("gdbscan.neighborhood", "Neighborhood predicate for Generalized DBSCAN");
        public static final OptionID COREPRED_ID = new OptionID("gdbscan.core", "Core point predicate for Generalized DBSCAN");
        public static final OptionID COREMODEL_ID = new OptionID("gdbscan.core-model", "Use a model that keeps track of core points. Needs more memory.");
        protected NeighborPredicate npred = null;
        protected CorePredicate corepred = null;
        protected boolean coremodel = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            ObjectParameter objectParameter;
            ObjectParameter objectParameter2 = new ObjectParameter(NEIGHBORHOODPRED_ID, (Class<?>)NeighborPredicate.class, EpsilonNeighborPredicate.class);
            if (parameterization.grab(objectParameter2)) {
                this.npred = (NeighborPredicate)objectParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(COREPRED_ID, (Class<?>)CorePredicate.class, MinPtsCorePredicate.class))) {
                this.corepred = (CorePredicate)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag = new Flag(COREMODEL_ID))) {
                this.coremodel = flag.isTrue();
            }
        }

        @Override
        protected GeneralizedDBSCAN makeInstance() {
            return new GeneralizedDBSCAN(this.npred, this.corepred, this.coremodel);
        }
    }

    public static class Instance<T> {
        protected static final int UNPROCESSED = 0;
        protected static final int NOISE = 1;
        protected final NeighborPredicate.Instance<T> npred;
        protected final CorePredicate.Instance<? super T> corepred;
        protected boolean coremodel = false;

        public Instance(NeighborPredicate.Instance<T> instance, CorePredicate.Instance<? super T> instance2, boolean bl) {
            this.npred = instance;
            this.corepred = instance2;
            this.coremodel = bl;
        }

        public Clustering<Model> run() {
            int n;
            int n2;
            Object object;
            DBIDs dBIDs = this.npred.getIDs();
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Generalized DBSCAN Clustering", dBIDs.size(), LOG) : null;
            IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters found", LOG) : null;
            WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 1, 0);
            TIntArrayList tIntArrayList = new TIntArrayList();
            tIntArrayList.add(0);
            tIntArrayList.add(0);
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
            int n3 = 2;
            ArrayModifiableDBIDs[] arrayModifiableDBIDsArray = dBIDs.iter();
            while (arrayModifiableDBIDsArray.valid()) {
                if (writableIntegerDataStore.intValue((DBIDRef)arrayModifiableDBIDsArray) == 0) {
                    object = this.npred.getNeighbors((DBIDRef)arrayModifiableDBIDsArray);
                    if (this.corepred.isCorePoint((DBIDRef)arrayModifiableDBIDsArray, object)) {
                        LOG.incrementProcessed(indefiniteProgress);
                        tIntArrayList.add(this.expandCluster((DBIDRef)arrayModifiableDBIDsArray, n3, writableIntegerDataStore, object, arrayModifiableDBIDs, finiteProgress));
                        ++n3;
                    } else {
                        writableIntegerDataStore.putInt((DBIDRef)arrayModifiableDBIDsArray, 1);
                        tIntArrayList.set(1, tIntArrayList.get(1) + 1);
                    }
                    LOG.incrementProcessed(finiteProgress);
                }
                arrayModifiableDBIDsArray.advance();
            }
            LOG.ensureCompleted(finiteProgress);
            LOG.setCompleted(indefiniteProgress);
            arrayModifiableDBIDsArray = new ArrayModifiableDBIDs[n3];
            object = this.coremodel ? new ArrayModifiableDBIDs[n3] : null;
            for (int i = 0; i < tIntArrayList.size(); ++i) {
                arrayModifiableDBIDsArray[i] = DBIDUtil.newArray(tIntArrayList.get(i));
                if (object == null) continue;
                object[i] = DBIDUtil.newArray(tIntArrayList.get(i));
            }
            Object object2 = dBIDs.iter();
            while (object2.valid()) {
                n2 = writableIntegerDataStore.intValue((DBIDRef)object2);
                n = n2 < 0 ? -n2 : n2;
                arrayModifiableDBIDsArray[n].add((DBIDRef)object2);
                if (object != null && n2 > 1) {
                    object[n].add((DBIDRef)object2);
                }
                object2.advance();
            }
            writableIntegerDataStore.destroy();
            object2 = new Clustering("GDBSCAN", "gdbscan-clustering");
            for (n2 = 1; n2 < arrayModifiableDBIDsArray.length; ++n2) {
                n = n2 == 1 ? 1 : 0;
                AbstractModel abstractModel = this.coremodel ? new CoreObjectsModel((DBIDs)object[n2]) : ClusterModel.CLUSTER;
                ((Clustering)object2).addToplevelCluster(new Cluster<ClusterModel>(arrayModifiableDBIDsArray[n2], n != 0, (ClusterModel)abstractModel));
            }
            return object2;
        }

        protected int expandCluster(DBIDRef dBIDRef, int n, WritableIntegerDataStore writableIntegerDataStore, T t, ArrayModifiableDBIDs arrayModifiableDBIDs, FiniteProgress finiteProgress) {
            assert (arrayModifiableDBIDs.size() == 0);
            int n2 = 1 + this.processCorePoint(dBIDRef, t, n, writableIntegerDataStore, arrayModifiableDBIDs);
            DBIDVar dBIDVar = DBIDUtil.newVar();
            while (!arrayModifiableDBIDs.isEmpty()) {
                arrayModifiableDBIDs.pop(dBIDVar);
                T t2 = this.npred.getNeighbors(dBIDVar);
                if (this.corepred.isCorePoint(dBIDVar, t2)) {
                    n2 += this.processCorePoint(dBIDVar, t2, n, writableIntegerDataStore, arrayModifiableDBIDs);
                }
                LOG.incrementProcessed(finiteProgress);
            }
            return n2;
        }

        protected int processCorePoint(DBIDRef dBIDRef, T t, int n, WritableIntegerDataStore writableIntegerDataStore, ArrayModifiableDBIDs arrayModifiableDBIDs) {
            writableIntegerDataStore.putInt(dBIDRef, n);
            int n2 = 0;
            DBIDIter dBIDIter = this.npred.iterDBIDs(t);
            while (dBIDIter.valid()) {
                block5: {
                    block4: {
                        int n3;
                        block3: {
                            n3 = writableIntegerDataStore.intValue(dBIDIter);
                            if (n3 != 0) break block3;
                            arrayModifiableDBIDs.add(dBIDIter);
                            break block4;
                        }
                        if (n3 != 1) break block5;
                    }
                    ++n2;
                    writableIntegerDataStore.putInt(dBIDIter, -n);
                }
                dBIDIter.advance();
            }
            return n2;
        }
    }
}

