/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.CorePredicate;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="M. Ester, H.-P. Kriegel, J. Sander, X. Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96), Portland, OR, 1996", url="http://www.aaai.org/Papers/KDD/1996/KDD96-037")
public class MinPtsCorePredicate
implements CorePredicate {
    public static final Logging LOG = Logging.getLogger(MinPtsCorePredicate.class);
    protected int minpts;

    public MinPtsCorePredicate(int n) {
        this.minpts = n;
    }

    @Override
    public <T> CorePredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        return new Instance(this.minpts);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<?> simpleTypeInformation) {
        if (TypeUtil.DBIDS.isAssignableFromType(simpleTypeInformation)) {
            return true;
        }
        return TypeUtil.NEIGHBORLIST.isAssignableFromType(simpleTypeInformation);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected int minpts;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(DBSCAN.Parameterizer.MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.minpts = intParameter.intValue();
                if (this.minpts <= 2) {
                    LOG.warning("DBSCAN with minPts <= 2 is equivalent to single-link clustering at a single height. Consider using larger values of minPts.");
                }
            }
        }

        @Override
        protected MinPtsCorePredicate makeInstance() {
            return new MinPtsCorePredicate(this.minpts);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<DBIDs> {
        protected int minpts;

        public Instance(int n) {
            this.minpts = n;
        }

        @Override
        public boolean isCorePoint(DBIDRef dBIDRef, DBIDs dBIDs) {
            return dBIDs.size() >= this.minpts;
        }
    }
}

