/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.List;

@Reference(title="Clustering my means of Medoids", authors="Kaufman, L. and Rousseeuw, P.J.", booktitle="Statistical Data Analysis Based on the L_1\u2013Norm and Related Methods")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.PAMInitialMeans"})
public class PAMInitialMeans<O>
implements KMeansInitialization<NumberVector>,
KMedoidsInitialization<O> {
    private static final Logging LOG = Logging.getLogger(PAMInitialMeans.class);

    @Override
    public <T extends NumberVector, V extends NumberVector> List<V> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<V> factory) {
        if (relation.size() < n) {
            throw new AbortException("Database has less than k objects.");
        }
        Relation<T> relation2 = relation;
        NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction2 = numberVectorDistanceFunction;
        DistanceQuery<? super T> distanceQuery = database.getDistanceQuery(relation2, numberVectorDistanceFunction2, new Object[0]);
        DBIDs dBIDs = this.chooseInitialMedoids(n, relation2.getDBIDs(), (DistanceQuery<? super O>)distanceQuery);
        ArrayList<V> arrayList = new ArrayList<V>(n);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            arrayList.add(factory.newNumberVector((NumberVector)relation.get(dBIDIter)));
            dBIDIter.advance();
        }
        return arrayList;
    }

    @Override
    public DBIDs chooseInitialMedoids(int n, DBIDs dBIDs, DistanceQuery<? super O> distanceQuery) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        Object object = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        Object object2 = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        Object object3 = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        double d = Double.POSITIVE_INFINITY;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Choosing initial mean", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2 = 0.0;
            Object object4 = dBIDs.iter();
            while (object4.valid()) {
                double d3 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)object4);
                d2 += d3;
                object3.putDouble((DBIDRef)object4, d3);
                object4.advance();
            }
            if (d2 < d) {
                d = d2;
                dBIDVar.set(dBIDIter);
                object4 = object;
                object = object3;
                object3 = object4;
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        arrayModifiableDBIDs.add(dBIDVar);
        assert (object != null);
        FiniteProgress finiteProgress2 = LOG.isVerbose() ? new FiniteProgress("Choosing initial centers", n, LOG) : null;
        LOG.incrementProcessed(finiteProgress2);
        for (int i = 1; i < n; ++i) {
            double d4 = Double.POSITIVE_INFINITY;
            dBIDVar.unset();
            Object object5 = dBIDs.iter();
            while (object5.valid()) {
                if (!arrayModifiableDBIDs.contains((DBIDRef)object5)) {
                    double d5 = 0.0;
                    Object object6 = dBIDs.iter();
                    while (object6.valid()) {
                        double d6 = MathUtil.min(distanceQuery.distance((DBIDRef)object5, (DBIDRef)object6), object.doubleValue((DBIDRef)object6));
                        d5 += d6;
                        object3.put((DBIDRef)object6, d6);
                        object6.advance();
                    }
                    if (d5 < d4) {
                        d4 = d5;
                        dBIDVar.set((DBIDRef)object5);
                        object6 = object2;
                        object2 = object3;
                        object3 = object6;
                    }
                }
                object5.advance();
            }
            if (!dBIDVar.isSet()) {
                throw new AbortException("No median found that improves the criterion function?!? Too many infinite distances.");
            }
            arrayModifiableDBIDs.add(dBIDVar);
            object5 = object2;
            object2 = object;
            object = object5;
            LOG.incrementProcessed(finiteProgress2);
        }
        LOG.ensureCompleted(finiteProgress2);
        object.destroy();
        object2.destroy();
        object3.destroy();
        return arrayModifiableDBIDs;
    }

    public static class Parameterizer<V>
    extends AbstractParameterizer {
        @Override
        protected PAMInitialMeans<V> makeInstance() {
            return new PAMInitialMeans();
        }
    }
}

