/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.SubspaceClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.Subspace;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.model.SubspaceModel;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ProxyDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionSelectingSubspaceDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

@Title(value="SUBCLU: Density connected Subspace Clustering")
@Description(value="Algorithm to detect arbitrarily shaped and positioned clusters in subspaces. SUBCLU delivers for each subspace the same clusters DBSCAN would have found, when applied to this subspace seperately.")
@Reference(authors="K. Kailing, H.-P. Kriegel, P. Kr\u00f6ger", title="Density connected Subspace Clustering for High Dimensional Data", booktitle="Proc. SIAM Int. Conf. on Data Mining (SDM'04), Lake Buena Vista, FL, 2004", url="http://www.siam.org/meetings/sdm04/proceedings/sdm04_023.pdf")
public class SUBCLU<V extends NumberVector>
extends AbstractAlgorithm<Clustering<SubspaceModel>>
implements SubspaceClusteringAlgorithm<SubspaceModel> {
    private static final Logging LOG = Logging.getLogger(SUBCLU.class);
    public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("subclu.distancefunction", "Distance function to determine the distance between database objects.");
    public static final OptionID EPSILON_ID = new OptionID("subclu.epsilon", "The maximum radius of the neighborhood to be considered.");
    public static final OptionID MINPTS_ID = new OptionID("subclu.minpts", "Threshold for minimum number of points in the epsilon-neighborhood of a point.");
    private DimensionSelectingSubspaceDistanceFunction<V> distanceFunction;
    private double epsilon;
    private int minpts;
    private Clustering<SubspaceModel> result;

    public SUBCLU(DimensionSelectingSubspaceDistanceFunction<V> dimensionSelectingSubspaceDistanceFunction, double d, int n) {
        this.distanceFunction = dimensionSelectingSubspaceDistanceFunction;
        this.epsilon = d;
        this.minpts = n;
    }

    public Clustering<SubspaceModel> run(Relation<V> relation) {
        Object object;
        Object object2;
        List<Object> list;
        Iterator<Subspace> iterator;
        int n;
        int n2 = RelationUtil.dimensionality(relation);
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress(n2) : null;
        LOG.beginStep(stepProgress, 1, "Generate all 1-dimensional clusters.");
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        ArrayList<Iterator<Subspace>> arrayList = new ArrayList<Iterator<Subspace>>();
        hashMap.put(0, arrayList);
        TreeMap<Subspace, List<Cluster<Model>>> treeMap = new TreeMap<Subspace, List<Cluster<Model>>>(new Subspace.DimensionComparator());
        for (n = 0; n < n2; ++n) {
            iterator = new Subspace(n);
            list = this.runDBSCAN(relation, null, (Subspace)((Object)iterator));
            if (LOG.isDebuggingFiner()) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append('\n').append(list.size()).append(" clusters in subspace ").append(((Subspace)((Object)iterator)).dimensonsToString()).append(": \n");
                for (Object object3 : list) {
                    ((StringBuilder)object2).append("      " + ((Cluster)object3).getIDs() + "\n");
                }
                LOG.debugFiner(((StringBuilder)object2).toString());
            }
            if (list.isEmpty()) continue;
            arrayList.add(iterator);
            treeMap.put((Subspace)((Object)iterator), (List<Cluster<Model>>)list);
        }
        for (n = 0; n < n2 - 1; ++n) {
            if (stepProgress != null) {
                stepProgress.beginStep(n + 2, "Generate " + (n + 2) + "-dimensional clusters from " + (n + 1) + "-dimensional clusters.", LOG);
            }
            if ((iterator = (List)hashMap.get(n)) == null || iterator.isEmpty()) {
                if (stepProgress == null) break;
                for (int i = n + 1; i < n2 - 1; ++i) {
                    stepProgress.beginStep(i + 2, "Generation of" + (i + 2) + "-dimensional clusters not applicable, because no more " + (n + 2) + "-dimensional subspaces found.", LOG);
                }
                break;
            }
            list = this.generateSubspaceCandidates((List<Subspace>)((Object)iterator));
            object2 = new ArrayList();
            for (Object object3 : list) {
                List<Cluster<Model>> list2;
                object = this.bestSubspace((List<Subspace>)((Object)iterator), (Subspace)object3, treeMap);
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine("best subspace of " + ((Subspace)object3).dimensonsToString() + ": " + ((Subspace)object).dimensonsToString());
                }
                List<Cluster<Model>> list3 = treeMap.get(object);
                ArrayList<Cluster<Model>> arrayList2 = new ArrayList<Cluster<Model>>();
                for (Cluster<Model> cluster : list3) {
                    list2 = this.runDBSCAN(relation, cluster.getIDs(), (Subspace)object3);
                    if (list2.isEmpty()) continue;
                    arrayList2.addAll(list2);
                }
                if (LOG.isDebuggingFine()) {
                    Cluster<Model> cluster;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(arrayList2.size() + " cluster(s) in subspace " + object3 + ": \n");
                    cluster = arrayList2.iterator();
                    while (cluster.hasNext()) {
                        list2 = (Cluster)cluster.next();
                        stringBuilder.append("      " + ((Cluster)((Object)list2)).getIDs() + "\n");
                    }
                    LOG.debugFine(stringBuilder.toString());
                }
                if (arrayList2.isEmpty()) continue;
                object2.add(object3);
                treeMap.put((Subspace)object3, arrayList2);
            }
            if (object2.isEmpty()) continue;
            hashMap.put(n + 1, object2);
        }
        n = 1;
        this.result = new Clustering("SUBCLU clustering", "subclu-clustering");
        for (Subspace subspace : treeMap.descendingKeySet()) {
            object2 = (List)treeMap.get(subspace);
            Iterator<Object> iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                Object object3;
                object3 = (Cluster)iterator2.next();
                object = new Cluster(((Cluster)object3).getIDs());
                ((Cluster)object).setModel(new SubspaceModel(subspace, Centroid.make(relation, ((Cluster)object3).getIDs())));
                ((Cluster)object).setName("cluster_" + n++);
                this.result.addToplevelCluster((Cluster<SubspaceModel>)object);
            }
        }
        LOG.setCompleted(stepProgress);
        return this.result;
    }

    public Clustering<SubspaceModel> getResult() {
        return this.result;
    }

    private List<Cluster<Model>> runDBSCAN(Relation<V> relation, DBIDs dBIDs, Subspace subspace) {
        this.distanceFunction.setSelectedDimensions(subspace.getDimensions());
        if (dBIDs == null) {
            dBIDs = relation.getDBIDs();
        }
        ProxyDatabase proxyDatabase = new ProxyDatabase(dBIDs, relation);
        DBSCAN<V> dBSCAN = new DBSCAN<V>(this.distanceFunction, this.epsilon, this.minpts);
        if (LOG.isVerbose()) {
            LOG.verbose("\nRun DBSCAN on subspace " + subspace.dimensonsToString());
        }
        Clustering clustering = (Clustering)dBSCAN.run(proxyDatabase);
        List list = clustering.getAllClusters();
        ArrayList<Cluster<Model>> arrayList = new ArrayList<Cluster<Model>>();
        for (Cluster cluster : list) {
            if (cluster.isNoise()) continue;
            arrayList.add(cluster);
        }
        return arrayList;
    }

    private List<Subspace> generateSubspaceCandidates(List<Subspace> list) {
        ArrayList<Subspace> arrayList = new ArrayList<Subspace>();
        if (list.isEmpty()) {
            return arrayList;
        }
        int n = list.get(0).dimensionality();
        StringBuilder stringBuilder = new StringBuilder("\n");
        if (LOG.isDebuggingFiner()) {
            stringBuilder.append("subspaces ").append(list).append('\n');
        }
        for (int i = 0; i < list.size(); ++i) {
            Subspace subspace = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                Subspace subspace2 = list.get(j);
                Subspace subspace3 = subspace.join(subspace2);
                if (subspace3 == null) continue;
                if (LOG.isDebuggingFiner()) {
                    stringBuilder.append("candidate: ").append(subspace3.dimensonsToString()).append('\n');
                }
                List<Subspace> list2 = this.lowerSubspaces(subspace3);
                if (LOG.isDebuggingFiner()) {
                    stringBuilder.append("lowerSubspaces: ").append(list2).append('\n');
                }
                boolean bl = false;
                for (Subspace subspace4 : list2) {
                    if (list.contains(subspace4)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(subspace3);
            }
        }
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner(stringBuilder.toString());
        }
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(n + 1).append("-dimensional candidate subspaces: ");
            for (Subspace subspace : arrayList) {
                stringBuilder2.append(subspace.dimensonsToString()).append(' ');
            }
            LOG.debug(stringBuilder2.toString());
        }
        return arrayList;
    }

    private List<Subspace> lowerSubspaces(Subspace subspace) {
        int n = subspace.dimensionality();
        if (n <= 1) {
            return null;
        }
        ArrayList<Subspace> arrayList = new ArrayList<Subspace>();
        long[] lArray = subspace.getDimensions();
        int n2 = BitsUtil.nextSetBit(lArray, 0);
        while (n2 >= 0) {
            long[] lArray2 = (long[])lArray.clone();
            BitsUtil.clearI(lArray2, n2);
            arrayList.add(new Subspace(lArray2));
            n2 = BitsUtil.nextSetBit(lArray, n2 + 1);
        }
        return arrayList;
    }

    private Subspace bestSubspace(List<Subspace> list, Subspace subspace, TreeMap<Subspace, List<Cluster<Model>>> treeMap) {
        Subspace subspace2 = null;
        for (Subspace subspace3 : list) {
            int n = Integer.MAX_VALUE;
            if (!subspace3.isSubspace(subspace)) continue;
            List<Cluster<Model>> list2 = treeMap.get(subspace3);
            for (Cluster<Model> cluster : list2) {
                int n2 = cluster.size();
                if (n2 >= n) continue;
                n = n2;
                subspace2 = subspace3;
            }
        }
        return subspace2;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected int minpts = 0;
        protected double epsilon;
        protected DimensionSelectingSubspaceDistanceFunction<V> distance = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_FUNCTION_ID, (Class<?>)DimensionSelectingSubspaceDistanceFunction.class, SubspaceEuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (DimensionSelectingSubspaceDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(EPSILON_ID))) {
                this.epsilon = (Double)doubleParameter.getValue();
            }
            IntParameter intParameter = new IntParameter(MINPTS_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.minpts = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected SUBCLU<V> makeInstance() {
            return new SUBCLU<V>(this.distance, this.epsilon, this.minpts);
        }
    }
}

