/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.AbstractFrequentItemsetAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.OneItemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.SparseItemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.SparseFeatureVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Reference(title="New Algorithms for Fast Discovery of Association Rules", authors="M.J. Zaki, S. Parthasarathy, M. Ogihara, and W. Li", booktitle="Proc. 3rd ACM SIGKDD '97 Int. Conf. on Knowledge Discovery and Data Mining", url="http://www.aaai.org/Library/KDD/1997/kdd97-060.php")
public class Eclat
extends AbstractFrequentItemsetAlgorithm {
    private static final Logging LOG = Logging.getLogger(Eclat.class);
    private static final String STAT = Eclat.class.getName() + ".";

    public Eclat(double d, int n, int n2) {
        super(d, n, n2);
    }

    public FrequentItemsetsResult run(Database database, Relation<BitVector> relation) {
        int n = RelationUtil.dimensionality(relation);
        VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation = RelationUtil.assumeVectorField(relation);
        int n2 = this.getMinimumSupport(relation.size());
        LOG.verbose("Build 1-dimensional transaction lists.");
        Duration duration = LOG.newDuration(STAT + "eclat.transposition.time").begin();
        DBIDs[] dBIDsArray = this.buildIndex(relation, n, n2);
        LOG.statistics(duration.end());
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Building frequent itemsets", dBIDsArray.length, LOG) : null;
        Duration duration2 = LOG.newDuration(STAT + "eclat.extraction.time").begin();
        ArrayList<Itemset> arrayList = new ArrayList<Itemset>();
        for (int i = 0; i < dBIDsArray.length; ++i) {
            LOG.incrementProcessed(finiteProgress);
            this.extractItemsets(dBIDsArray, i, n2, arrayList);
        }
        LOG.ensureCompleted(finiteProgress);
        Collections.sort(arrayList);
        LOG.statistics(duration2.end());
        LOG.statistics(new LongStatistic(STAT + "frequent-itemsets", arrayList.size()));
        return new FrequentItemsetsResult("Eclat", "eclat", arrayList, vectorFieldTypeInformation);
    }

    private void extractItemsets(DBIDs[] dBIDsArray, int n, int n2, List<Itemset> list) {
        int[] nArray = new int[dBIDsArray.length];
        DBIDs dBIDs = dBIDsArray[n];
        if (dBIDs == null || dBIDs.size() < n2) {
            return;
        }
        if (this.minlength <= 1) {
            list.add(new OneItemset(n, dBIDs.size()));
        }
        if (this.maxlength > 1) {
            nArray[0] = n;
            this.extractItemsets(dBIDs, dBIDsArray, nArray, 1, n + 1, n2, list);
        }
    }

    private void extractItemsets(DBIDs dBIDs, DBIDs[] dBIDsArray, int[] nArray, int n, int n2, int n3, List<Itemset> list) {
        for (int i = n2; i < dBIDsArray.length; ++i) {
            DBIDs dBIDs2;
            if (dBIDsArray[i] == null || (dBIDs2 = this.mergeJoin(dBIDs, dBIDsArray[i])).size() < n3) continue;
            nArray[n] = i;
            int[] nArray2 = Arrays.copyOf(nArray, n + 1);
            if (n >= this.minlength) {
                list.add(new SparseItemset(nArray2, dBIDs2.size()));
            }
            if (n >= this.maxlength) continue;
            this.extractItemsets(dBIDs2, dBIDsArray, nArray, n + 1, i + 1, n3, list);
        }
    }

    private DBIDs mergeJoin(DBIDs dBIDs, DBIDs dBIDs2) {
        assert (!(dBIDs instanceof HashSetDBIDs));
        assert (!(dBIDs2 instanceof HashSetDBIDs));
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        DBIDIter dBIDIter = dBIDs.iter();
        DBIDIter dBIDIter2 = dBIDs2.iter();
        while (dBIDIter.valid() && dBIDIter2.valid()) {
            int n = DBIDUtil.compare(dBIDIter, dBIDIter2);
            if (n < 0) {
                dBIDIter.advance();
                continue;
            }
            if (n > 0) {
                dBIDIter2.advance();
                continue;
            }
            arrayModifiableDBIDs.add(dBIDIter);
            dBIDIter.advance();
            dBIDIter2.advance();
        }
        return arrayModifiableDBIDs;
    }

    private DBIDs[] buildIndex(Relation<BitVector> relation, int n, int n2) {
        DBIDs[] dBIDsArray = new ArrayModifiableDBIDs[n];
        for (int i = 0; i < n; ++i) {
            dBIDsArray[i] = DBIDUtil.newArray();
        }
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            SparseFeatureVector sparseFeatureVector = relation.get(dBIDIter);
            int n3 = sparseFeatureVector.iter();
            while (sparseFeatureVector.iterValid(n3)) {
                dBIDsArray[sparseFeatureVector.iterDim(n3)].add(dBIDIter);
                n3 = sparseFeatureVector.iterAdvance(n3);
            }
            dBIDIter.advance();
        }
        for (int i = 0; i < n; ++i) {
            if (dBIDsArray[i].size() < n2) {
                dBIDsArray[i] = null;
                continue;
            }
            dBIDsArray[i].sort();
        }
        return dBIDsArray;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.BIT_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractFrequentItemsetAlgorithm.Parameterizer {
        @Override
        protected Eclat makeInstance() {
            return new Eclat(this.minsupp, this.minlength, this.maxlength);
        }
    }
}

