/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.AbstractFrequentItemsetAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.OneItemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.SparseItemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.SparseFeatureVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.IntegerComparator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@Reference(authors="J. Han, J. Pei, Y. Yin", title="Mining frequent patterns without candidate generation", booktitle="Proceedings of the 2000 ACM SIGMOD international conference on Management of data ", url="http://dx.doi.org/10.1145/342009.335372")
public class FPGrowth
extends AbstractFrequentItemsetAlgorithm {
    private static final Logging LOG = Logging.getLogger(FPGrowth.class);
    private static final String STAT = FPGrowth.class.getName() + ".";

    public FPGrowth(double d, int n, int n2) {
        super(d, n, n2);
    }

    public FrequentItemsetsResult run(Database database, Relation<BitVector> relation) {
        Object object;
        int n = RelationUtil.dimensionality(relation);
        final VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation = RelationUtil.assumeVectorField(relation);
        int n2 = this.getMinimumSupport(relation.size());
        LOG.verbose("Finding item frequencies for ordering.");
        int[] nArray = this.countItemSupport(relation, n);
        int[] nArray2 = new int[n];
        final int[] nArray3 = this.buildIndex(nArray, nArray2, n2);
        int n3 = nArray3.length;
        LOG.statistics(new LongStatistic(STAT + "raw-items", n));
        LOG.statistics(new LongStatistic(STAT + "raw-transactions", relation.size()));
        LOG.statistics(new DoubleStatistic(STAT + "minsupp-relative", (double)n2 / (double)relation.size()));
        LOG.statistics(new LongStatistic(STAT + "minsupp-absolute", n2));
        LOG.verbose("Building FP-Tree.");
        Duration duration = LOG.newDuration(STAT + "fp-tree.construction.time").begin();
        FPTree fPTree = this.buildFPTree(relation, nArray2, n3);
        if (LOG.isStatistics()) {
            fPTree.logStatistics();
        }
        fPTree.reduceMemory();
        LOG.statistics(duration.end());
        if (LOG.isDebuggingFinest()) {
            object = new StringBuilder();
            ((StringBuilder)object).append("FP-tree:\n");
            fPTree.appendTo((StringBuilder)object, new FPNode.Translator(){

                @Override
                public void appendTo(StringBuilder stringBuilder, int n) {
                    String string = vectorFieldTypeInformation.getLabel(nArray3[n]);
                    stringBuilder.append(string != null ? string : Integer.toString(n));
                }
            });
            LOG.debugFinest(((StringBuilder)object).toString());
        }
        LOG.verbose("Extracting frequent patterns.");
        object = LOG.newDuration(STAT + "fp-growth.extraction.time").begin();
        final IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Frequent itemsets", LOG) : null;
        final ArrayList<Itemset> arrayList = new ArrayList<Itemset>();
        fPTree.extract(n2, this.minlength, this.maxlength, true, new FPTree.Collector(){

            @Override
            public void collect(int n, int[] nArray, int n2, int n3) {
                if (n3 - n2 == 1) {
                    arrayList.add(new OneItemset(nArray3[nArray[n2]], n));
                    LOG.incrementProcessed(indefiniteProgress);
                    return;
                }
                int[] nArray2 = new int[n3 - n2];
                int n4 = 0;
                for (int i = n2; i < n3; ++i) {
                    nArray2[n4++] = nArray3[nArray[i]];
                }
                Arrays.sort(nArray2);
                arrayList.add(new SparseItemset(nArray2, n));
                LOG.incrementProcessed(indefiniteProgress);
            }
        });
        LOG.setCompleted(indefiniteProgress);
        Collections.sort(arrayList);
        LOG.statistics(object.end());
        LOG.statistics(new LongStatistic(STAT + "frequent-itemsets", arrayList.size()));
        return new FrequentItemsetsResult("FP-Growth", "fp-growth", arrayList, vectorFieldTypeInformation);
    }

    private int[] countItemSupport(Relation<BitVector> relation, int n) {
        int[] nArray = new int[n];
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Finding frequent 1-items", relation.size(), LOG) : null;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            SparseFeatureVector sparseFeatureVector = relation.get(dBIDIter);
            int n2 = sparseFeatureVector.iter();
            while (sparseFeatureVector.iterValid(n2)) {
                int n3 = sparseFeatureVector.iterDim(n2);
                nArray[n3] = nArray[n3] + 1;
                n2 = sparseFeatureVector.iterAdvance(n2);
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        return nArray;
    }

    private FPTree buildFPTree(Relation<BitVector> relation, int[] nArray, int n) {
        FPTree fPTree = new FPTree(n);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Building FP-tree", relation.size(), LOG) : null;
        int[] nArray2 = new int[n];
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            int n2 = 0;
            SparseFeatureVector sparseFeatureVector = relation.get(dBIDIter);
            int n3 = sparseFeatureVector.iter();
            while (sparseFeatureVector.iterValid(n3)) {
                int n4 = nArray[sparseFeatureVector.iterDim(n3)];
                if (n4 >= 0) {
                    nArray2[n2++] = n4;
                }
                n3 = sparseFeatureVector.iterAdvance(n3);
            }
            if (n2 >= this.minlength) {
                Arrays.sort(nArray2, 0, n2);
                fPTree.insert(nArray2, 0, n2, 1);
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        return fPTree;
    }

    private int[] buildIndex(final int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < n) continue;
            ++n3;
        }
        int[] nArray3 = new int[n3];
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] < n) continue;
            nArray3[n4++] = n2;
        }
        IntegerArrayQuickSort.sort(nArray3, new IntegerComparator(){

            @Override
            public int compare(int n, int n2) {
                return Integer.compare(nArray[n2], nArray[n]);
            }
        });
        Arrays.fill(nArray2, -1);
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray2[nArray3[n2]] = n2;
        }
        return nArray3;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.BIT_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractFrequentItemsetAlgorithm.Parameterizer {
        @Override
        protected FPGrowth makeInstance() {
            return new FPGrowth(this.minsupp, this.minlength, this.maxlength);
        }
    }

    public static class FPNode {
        FPNode parent;
        FPNode sibling;
        int key;
        int count = 0;
        int numchildren = 0;
        FPNode[] children = EMPTY_CHILDREN;
        static final FPNode[] EMPTY_CHILDREN = new FPNode[0];
        final int INITIAL_SIZE = 7;
        private static final char[] SPACES = "                ".toCharArray();

        public FPNode(FPNode fPNode, int n) {
            this.parent = fPNode;
            this.key = n;
        }

        public void insert(FPTree fPTree, int[] nArray, int n, int n2, int n3) {
            this.count += n3;
            if (n == n2) {
                return;
            }
            int n4 = nArray[n];
            for (int i = 0; i < this.numchildren; ++i) {
                FPNode fPNode = this.children[i];
                if (fPNode.key != n4) continue;
                fPNode.insert(fPTree, nArray, n + 1, n2, n3);
                return;
            }
            if (this.numchildren == this.children.length) {
                this.ensureSize();
            }
            FPNode fPNode = fPTree.newNode(this, n4);
            this.children[this.numchildren++] = fPNode;
            FPNode fPNode2 = fPNode;
            fPNode2.insert(fPTree, nArray, n + 1, n2, n3);
        }

        private void ensureSize() {
            if (this.children == EMPTY_CHILDREN) {
                this.children = new FPNode[1];
                return;
            }
            int n = this.children.length == 1 ? 7 : this.children.length << 1;
            this.children = Arrays.copyOf(this.children, n);
        }

        public void appendTo(StringBuilder stringBuilder, Translator translator) {
            this.appendTo(stringBuilder, translator, 0);
        }

        private void appendTo(StringBuilder stringBuilder, Translator translator, int n) {
            if (this.key > 0) {
                translator.appendTo(stringBuilder, this.key);
                stringBuilder.append(": ");
            }
            stringBuilder.append(this.count).append("\n");
            for (int i = 0; i < this.numchildren; ++i) {
                for (int j = n; j > 0; j -= SPACES.length) {
                    stringBuilder.append(SPACES, 0, Math.min(j, SPACES.length));
                }
                this.children[i].appendTo(stringBuilder, translator, n + 1);
            }
        }

        public void reduceMemory() {
            if (this.children == null) {
                return;
            }
            for (int i = 0; i < this.numchildren; ++i) {
                this.children[i].reduceMemory();
            }
            this.children = null;
        }

        public static interface Translator {
            public void appendTo(StringBuilder var1, int var2);
        }
    }

    public static class FPTree
    extends FPNode {
        FPNode[] header;
        int nodes = 1;

        public FPTree(int n) {
            super(null, -1);
            this.header = new FPNode[n];
        }

        public void insert(int[] nArray, int n, int n2, int n3) {
            this.insert(this, nArray, n, n2, n3);
        }

        public FPNode newNode(FPNode fPNode, int n) {
            FPNode fPNode2 = new FPNode(fPNode, n);
            fPNode2.sibling = this.header[n];
            this.header[n] = fPNode2;
            ++this.nodes;
            return fPNode2;
        }

        public void extract(int n, int n2, int n3, boolean bl, Collector collector) {
            int[] nArray = new int[this.header.length];
            int[] nArray2 = new int[this.header.length];
            int[] nArray3 = new int[this.header.length];
            int n4 = n2 > 1 ? n2 - 1 : 0;
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Extracting itemsets", this.header.length - n4, LOG) : null;
            for (int i = this.header.length - 1; i >= n4; --i) {
                this.extract(n, n2, n3, i, nArray, 0, nArray2, nArray3, bl, collector);
                LOG.incrementProcessed(finiteProgress);
            }
            LOG.ensureCompleted(finiteProgress);
        }

        private void extract(int n, int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int[] nArray3, boolean bl, Collector collector) {
            if (this.header[n4] == null) {
                return;
            }
            if (this.header[n4].sibling == null) {
                if (this.header[n4].count < n) {
                    return;
                }
                this.extractLinear(this.header[n4].count, n, n2, n3, n4, nArray, n5, nArray2, collector);
                if (bl) {
                    Arrays.fill(this.header, null);
                }
                return;
            }
            int n6 = 0;
            FPNode fPNode = this.header[n4];
            while (fPNode != null) {
                n6 += fPNode.count;
                fPNode = fPNode.sibling;
            }
            if (n6 < n) {
                return;
            }
            Arrays.fill(nArray3, 0);
            fPNode = this.header[n4];
            while (fPNode != null) {
                FPNode fPNode2 = fPNode.parent;
                while (fPNode2.key >= 0) {
                    int n7 = fPNode2.key;
                    nArray3[n7] = nArray3[n7] + fPNode.count;
                    fPNode2 = fPNode2.parent;
                }
                fPNode = fPNode.sibling;
            }
            int n8 = n2 - (n5 + 1);
            if (n8 > 0) {
                int n9 = 0;
                for (int i = 0; i < n4; ++i) {
                    if (nArray3[i] < n) continue;
                    ++n9;
                }
                if (n9 < n8) {
                    return;
                }
            }
            int n10 = n4 - 1;
            FPTree fPTree = new FPTree(n4);
            FPNode fPNode3 = this.header[n4];
            while (fPNode3 != null) {
                int n11 = nArray2.length;
                FPNode fPNode4 = fPNode3.parent;
                while (fPNode4.key >= 0) {
                    if (nArray3[fPNode4.key] >= n) {
                        nArray2[--n11] = fPNode4.key;
                    }
                    fPNode4 = fPNode4.parent;
                }
                if (nArray2.length - n11 >= n8) {
                    fPTree.insert(fPTree, nArray2, n11, nArray2.length, fPNode3.count);
                }
                fPNode3 = fPNode3.sibling;
            }
            fPTree.reduceMemory();
            nArray[n5++] = n4;
            if (n5 >= n2 && n5 <= n3) {
                collector.collect(n6, nArray, 0, n5);
            }
            for (int i = n10; i >= 0; --i) {
                fPTree.extract(n, n2, n3, i, nArray, n5, nArray2, nArray3, bl, collector);
            }
            if (bl) {
                this.header[n4] = null;
            }
        }

        private void extractLinear(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6, int[] nArray2, Collector collector) {
            int n7;
            int n8 = n3 - n6;
            if (n5 > 0 && n5 >= n8 && n6 < n4) {
                this.extractLinear(n, n2, n3, n4, n5 - 1, nArray, n6, nArray2, collector);
            }
            if (this.header[n5] == null || n5 + 1 < n8) {
                return;
            }
            int n9 = this.header[n5].count;
            if (n9 < n2) {
                return;
            }
            nArray[n6++] = n5;
            int n10 = n7 = n9 < n ? n9 : n;
            if (n6 >= n3 && n6 <= n4) {
                collector.collect(n7, nArray, 0, n6);
            }
            if (n5 > 0 && n6 < n4) {
                this.extractLinear(n7, n2, n3, n4, n5 - 1, nArray, n6, nArray2, collector);
            }
        }

        public void logStatistics() {
            LOG.statistics(new LongStatistic(STAT + "items", this.header.length));
            LOG.statistics(new LongStatistic(STAT + "nodes", this.nodes));
            LOG.statistics(new LongStatistic(STAT + "transactions", this.count));
        }

        public static interface Collector {
            public void collect(int var1, int[] var2, int var3, int var4);
        }
    }
}

