/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;

public class SmallDenseItemset
extends Itemset {
    long items;
    int length;

    public SmallDenseItemset(long l, int n) {
        this.items = l;
        this.length = n;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public boolean containedIn(BitVector bitVector) {
        return bitVector.contains(new long[]{this.items});
    }

    @Override
    public long[] getItems() {
        return new long[]{this.items};
    }

    public int hashCode() {
        return BitsUtil.hashCode(this.items);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Itemset) || ((Itemset)object).length() != 1) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.items == ((SmallDenseItemset)object).items;
    }

    @Override
    public int compareTo(Itemset itemset) {
        int n = Integer.compare(this.length, itemset.length());
        if (n != 0) {
            return n;
        }
        SmallDenseItemset smallDenseItemset = (SmallDenseItemset)itemset;
        return -Long.compare(Long.reverse(this.items), Long.reverse(smallDenseItemset.items));
    }

    @Override
    public StringBuilder appendTo(StringBuilder stringBuilder, VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation) {
        int n = BitsUtil.nextSetBit(this.items, 0);
        while (true) {
            String string;
            String string2 = string = vectorFieldTypeInformation != null ? vectorFieldTypeInformation.getLabel(n) : null;
            if (string == null) {
                stringBuilder.append(n);
            } else {
                stringBuilder.append(string);
            }
            n = BitsUtil.nextSetBit(this.items, n + 1);
            if (n < 0) break;
            stringBuilder.append(", ");
        }
        stringBuilder.append(": ").append(this.support);
        return stringBuilder;
    }
}

