/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="DWOF: Dynamic Window Outlier Factor")
@Description(value="Algorithm to compute dynamic-window outlier factors in a database based on the neighborhood size parameter 'k'")
@Reference(authors="R. Momtaz, N. Mohssen, M. A. Gowayyed", title="DWOF: A Robust Density-Based Outlier Detection Approach", booktitle="Pattern Recognition and Image Analysis, Proc. 6th Iberian Conference, IbPRIA 2013, Funchal, Madeira, Portugal, 2013.", url="http://dx.doi.org/10.1007%2F978-3-642-38628-2_61")
public class DWOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(DWOF.class);
    protected int k;
    private double delta = 1.1;

    public DWOF(DistanceFunction<? super O> distanceFunction, int n, double d) {
        super(distanceFunction);
        this.k = n + 1;
        this.delta = d;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        Object object2;
        WritableDataStore<ModifiableDBIDs> writableDataStore;
        IndefiniteProgress indefiniteProgress;
        DBIDs dBIDs = relation.getDBIDs();
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k, "heavy");
        RangeQuery<O> rangeQuery = database.getRangeQuery(distanceQuery, "heavy");
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("DWOF", 2) : null;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 30, 0.0);
        if (stepProgress != null) {
            stepProgress.beginStep(1, "Initializing objects' Radii", LOG);
        }
        WritableDoubleDataStore writableDoubleDataStore2 = DataStoreUtil.makeDoubleStorage(dBIDs, 3, 0.0);
        this.initializeRadii(dBIDs, kNNQuery, distanceQuery, writableDoubleDataStore2);
        Object object3 = DataStoreUtil.makeIntegerStorage(dBIDs, 2, 1);
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(dBIDs, 2, 1);
        int n = relation.size();
        if (stepProgress != null) {
            stepProgress.beginStep(2, "Clustering-Evaluating Cycles.", LOG);
        }
        IndefiniteProgress indefiniteProgress2 = indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Evaluating DWOFs", LOG) : null;
        while (n > 0) {
            LOG.incrementProcessed(indefiniteProgress);
            writableDataStore = dBIDs.iter();
            while (writableDataStore.valid()) {
                writableDoubleDataStore2.putDouble((DBIDRef)((Object)writableDataStore), writableDoubleDataStore2.doubleValue((DBIDRef)((Object)writableDataStore)) * this.delta);
                writableDataStore.advance();
            }
            writableDataStore = DataStoreUtil.makeStorage(dBIDs, 1, ModifiableDBIDs.class);
            this.clusterData(dBIDs, rangeQuery, writableDoubleDataStore2, writableDataStore);
            object2 = writableIntegerDataStore;
            writableIntegerDataStore = object3;
            object3 = object2;
            n = this.updateSizes(dBIDs, writableDataStore, writableIntegerDataStore);
            writableDataStore.destroy();
            object = dBIDs.iter();
            while (object.valid()) {
                double d = writableIntegerDataStore.intValue((DBIDRef)object) > 0 ? (double)(object3.intValue((DBIDRef)object) - 1) / (double)writableIntegerDataStore.intValue((DBIDRef)object) : 0.0;
                writableDoubleDataStore.putDouble((DBIDRef)object, writableDoubleDataStore.doubleValue((DBIDRef)object) + d);
                object.advance();
            }
        }
        LOG.setCompleted(indefiniteProgress);
        LOG.setCompleted(stepProgress);
        writableDataStore = new DoubleMinMax();
        object2 = relation.iterDBIDs();
        while (object2.valid()) {
            ((DoubleMinMax)((Object)writableDataStore)).put(writableDoubleDataStore.doubleValue((DBIDRef)object2));
            object2.advance();
        }
        object2 = new InvertedOutlierScoreMeta(((DoubleMinMax)((Object)writableDataStore)).getMin(), ((DoubleMinMax)((Object)writableDataStore)).getMax(), 0.0, Double.POSITIVE_INFINITY);
        object = new MaterializedDoubleRelation("Dynamic-Window Outlier Factors", "dwof-outlier", writableDoubleDataStore, dBIDs);
        return new OutlierResult((OutlierScoreMeta)object2, (DoubleRelation)object);
    }

    private void initializeRadii(DBIDs dBIDs, KNNQuery<O> kNNQuery, DistanceQuery<O> distanceQuery, WritableDoubleDataStore writableDoubleDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Calculating average kNN distances-", dBIDs.size(), LOG) : null;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        Mean mean = new Mean();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
            mean.reset();
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDIter)) {
                    DoubleDBIDListIter doubleDBIDListIter2 = kNNList.iter();
                    while (doubleDBIDListIter2.valid()) {
                        if (!DBIDUtil.equal(doubleDBIDListIter, doubleDBIDListIter2) && !DBIDUtil.equal(doubleDBIDListIter2, dBIDIter)) {
                            double d3 = distanceQuery.distance((DBIDRef)doubleDBIDListIter, (DBIDRef)doubleDBIDListIter2);
                            mean.put(d3);
                            if (d3 > 0.0 && d3 < d) {
                                d = d3;
                            }
                        }
                        doubleDBIDListIter2.advance();
                    }
                }
                doubleDBIDListIter.advance();
            }
            double d4 = mean.getMean();
            writableDoubleDataStore.putDouble(dBIDIter, d4);
            if (d4 < d2) {
                d2 = d4;
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            writableDoubleDataStore.putDouble(dBIDIter, d2 > 0.0 ? d * writableDoubleDataStore.doubleValue(dBIDIter) / d2 : Double.POSITIVE_INFINITY);
            dBIDIter.advance();
        }
    }

    private void clusterData(DBIDs dBIDs, RangeQuery<O> rangeQuery, WritableDoubleDataStore writableDoubleDataStore, WritableDataStore<ModifiableDBIDs> writableDataStore) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Density-Based Clustering", dBIDs.size(), LOG) : null;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            if (writableDataStore.get(dBIDIter) == null) {
                ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
                arrayModifiableDBIDs.add(dBIDIter);
                writableDataStore.put(dBIDIter, arrayModifiableDBIDs);
                LOG.incrementProcessed(finiteProgress);
                ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray();
                arrayModifiableDBIDs2.add(dBIDIter);
                DBIDMIter dBIDMIter = arrayModifiableDBIDs2.iter();
                while (dBIDMIter.valid()) {
                    double d = writableDoubleDataStore.doubleValue(dBIDMIter);
                    DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForDBID(dBIDMIter, d);
                    DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
                    while (doubleDBIDListIter.valid()) {
                        if (!DBIDUtil.equal(dBIDMIter, doubleDBIDListIter)) {
                            if (writableDataStore.get(doubleDBIDListIter) == null) {
                                arrayModifiableDBIDs.add(doubleDBIDListIter);
                                writableDataStore.put(doubleDBIDListIter, arrayModifiableDBIDs);
                                arrayModifiableDBIDs2.add(doubleDBIDListIter);
                                LOG.incrementProcessed(finiteProgress);
                            } else if (writableDataStore.get(doubleDBIDListIter) != arrayModifiableDBIDs) {
                                ModifiableDBIDs modifiableDBIDs = (ModifiableDBIDs)writableDataStore.get(doubleDBIDListIter);
                                arrayModifiableDBIDs.addDBIDs(modifiableDBIDs);
                                DBIDMIter dBIDMIter2 = modifiableDBIDs.iter();
                                while (dBIDMIter2.valid()) {
                                    writableDataStore.put(dBIDMIter2, arrayModifiableDBIDs);
                                    dBIDMIter2.advance();
                                }
                                modifiableDBIDs.clear();
                            }
                        }
                        doubleDBIDListIter.advance();
                    }
                    dBIDMIter.advance();
                }
            }
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
    }

    private int updateSizes(DBIDs dBIDs, WritableDataStore<ModifiableDBIDs> writableDataStore, WritableIntegerDataStore writableIntegerDataStore) {
        int n = 0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            int n2 = ((ModifiableDBIDs)writableDataStore.get(dBIDIter)).size();
            writableIntegerDataStore.putInt(dBIDIter, n2);
            if (n2 == 1) {
                ++n;
            }
            dBIDIter.advance();
        }
        return n;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = OptionID.getOrCreateOptionID("dwof.k", "Number of neighbors to get for DWOF score outlier detection.");
        public static final OptionID DELTA_ID = OptionID.getOrCreateOptionID("dwof.delta", "Radius increase factor.");
        protected int k;
        protected double delta = 1.1;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)((DoubleParameter)new DoubleParameter(DELTA_ID).setDefaultValue((Object)1.1)).addConstraint(CommonConstraints.GREATER_THAN_ONE_DOUBLE))) {
                this.delta = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected DWOF<O> makeInstance() {
            return new DWOF(this.distanceFunction, this.k, this.delta);
        }
    }
}

