/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="LDOF: Local Distance-Based Outlier Factor")
@Description(value="Local outlier detection appraoch suitable for scattered data by averaging the kNN distance over all k nearest neighbors")
@Reference(authors="K. Zhang, M. Hutter, H. Jin", title="A New Local Distance-Based Outlier Detection Approach for Scattered Real-World Data", booktitle="Proc. 13th Pacific-Asia Conference on Advances in Knowledge Discovery and Data Mining (PAKDD 2009)", url="http://dx.doi.org/10.1007/978-3-642-01307-2_84")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LDOF"})
public class LDOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LDOF.class);
    private static final double LDOF_BASELINE = 0.5;
    protected int k;

    public LDOF(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        if (LOG.isVerbose()) {
            LOG.verbose("Computing LDOFs");
        }
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("LDOF for objects", relation.size(), LOG) : null;
        Mean mean = new Mean();
        Mean mean2 = new Mean();
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            object = kNNQuery.getKNNForDBID((DBIDRef)object2, this.k);
            mean.reset();
            mean2.reset();
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            DoubleDBIDListIter doubleDBIDListIter2 = object.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, (DBIDRef)object2)) {
                    mean.put(doubleDBIDListIter.doubleValue());
                    doubleDBIDListIter2.seek(doubleDBIDListIter.getOffset() + 1);
                    while (doubleDBIDListIter2.valid()) {
                        if (!DBIDUtil.equal(doubleDBIDListIter2, (DBIDRef)object2)) {
                            mean2.put(distanceQuery.distance((DBIDRef)doubleDBIDListIter, (DBIDRef)doubleDBIDListIter2));
                        }
                        doubleDBIDListIter2.advance();
                    }
                }
                doubleDBIDListIter.advance();
            }
            double d = mean.getMean() / mean2.getMean();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                d = 1.0;
            }
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object2 = new MaterializedDoubleRelation("LDOF Outlier Score", "ldof-outlier", writableDoubleDataStore, relation.getDBIDs());
        object = new QuotientOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.5);
        return new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("ldof.k", "The number of nearest neighbors of an object to be considered for computing its LDOF_SCORE.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected LDOF<O> makeInstance() {
            return new LDOF(this.distanceFunction, this.k);
        }
    }
}

