/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.DatabaseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.SimpleKernelDensityLOF"})
public class SimpleKernelDensityLOF<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleKernelDensityLOF.class);
    protected int k;
    private KernelDensityFunction kernel;

    public SimpleKernelDensityLOF(int n, DistanceFunction<? super O> distanceFunction, KernelDensityFunction kernelDensityFunction) {
        super(distanceFunction);
        this.k = n + 1;
        this.kernel = kernelDensityFunction;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        double d;
        Object object;
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("KernelDensityLOF", 3) : null;
        int n = RelationUtil.dimensionality(relation);
        DBIDs dBIDs = relation.getDBIDs();
        LOG.beginStep(stepProgress, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNQuery<O> kNNQuery = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepProgress, 2, "Computing densities.");
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Densities", dBIDs.size(), LOG) : null;
        Object object2 = dBIDs.iter();
        while (object2.valid()) {
            object = kNNQuery.getKNNForDBID((DBIDRef)object2, this.k);
            int n2 = 0;
            double d2 = 0.0;
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, (DBIDRef)object2)) {
                    d = kNNQuery.getKNNForDBID(doubleDBIDListIter, this.k).getKNNDistance();
                    if (d == 0.0) {
                        d2 = Double.POSITIVE_INFINITY;
                        break;
                    }
                    double d3 = doubleDBIDListIter.doubleValue() / d;
                    d2 += this.kernel.density(d3) / MathUtil.powi(d, n);
                    ++n2;
                }
                doubleDBIDListIter.advance();
            }
            double d4 = d2 / (double)n2;
            writableDoubleDataStore.putDouble((DBIDRef)object2, d4);
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.beginStep(stepProgress, 3, "Computing KLOFs.");
        object2 = DataStoreUtil.makeDoubleStorage(dBIDs, 4);
        object = new DoubleMinMax();
        FiniteProgress finiteProgress2 = LOG.isVerbose() ? new FiniteProgress("KLOF_SCORE for objects", dBIDs.size(), LOG) : null;
        Object object3 = dBIDs.iter();
        while (object3.valid()) {
            double d5 = writableDoubleDataStore.doubleValue((DBIDRef)object3);
            if (d5 > 0.0) {
                KNNList kNNList = kNNQuery.getKNNForDBID((DBIDRef)object3, this.k);
                double d6 = 0.0;
                int n3 = 0;
                DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
                while (doubleDBIDListIter.valid()) {
                    if (!DBIDUtil.equal(doubleDBIDListIter, (DBIDRef)object3)) {
                        d6 += writableDoubleDataStore.doubleValue(doubleDBIDListIter);
                        ++n3;
                    }
                    doubleDBIDListIter.advance();
                }
                d = d5 == Double.POSITIVE_INFINITY ? (d6 == Double.POSITIVE_INFINITY ? 1.0 : 0.0) : d6 / ((double)n3 * d5);
            } else {
                d = 1.0;
            }
            object2.putDouble((DBIDRef)object3, d);
            ((DoubleMinMax)object).put(d);
            LOG.incrementProcessed(finiteProgress2);
            object3.advance();
        }
        LOG.ensureCompleted(finiteProgress2);
        LOG.setCompleted(stepProgress);
        object3 = new MaterializedDoubleRelation("Kernel Density Local Outlier Factor", "kernel-density-slof-outlier", (DoubleDataStore)object2, dBIDs);
        QuotientOutlierScoreMeta quotientOutlierScoreMeta = new QuotientOutlierScoreMeta(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult outlierResult = new OutlierResult(quotientOutlierScoreMeta, (DoubleRelation)object3);
        return outlierResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID KERNEL_ID = new OptionID("kernellof.kernel", "Kernel to use for kernel density LOF.");
        protected int k;
        KernelDensityFunction kernel;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(LOF.Parameterizer.K_ID).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, EpanechnikovKernelDensityFunction.class))) {
                this.kernel = (KernelDensityFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected SimpleKernelDensityLOF<O> makeInstance() {
            return new SimpleKernelDensityLOF(this.k, this.distanceFunction, this.kernel);
        }
    }
}

