/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;

public class LRDProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;
    private DoubleDataStore kdists;

    public LRDProcessor(DataStore<? extends KNNList> dataStore, DoubleDataStore doubleDataStore) {
        this.knns = dataStore;
        this.kdists = doubleDataStore;
    }

    @Override
    public Instance instantiate(Executor executor) {
        return new Instance(executor.getInstance(this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        protected Instance(SharedDouble.Instance instance) {
            super(instance);
        }

        @Override
        public void map(DBIDRef dBIDRef) {
            KNNList kNNList = (KNNList)LRDProcessor.this.knns.get(dBIDRef);
            double d = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDRef)) {
                    d += MathUtil.max(LRDProcessor.this.kdists.doubleValue(doubleDBIDListIter), doubleDBIDListIter.doubleValue());
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            this.output.set(d > 0.0 ? (double)n / d : Double.POSITIVE_INFINITY);
        }
    }
}

