/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;

public class SimplifiedLRDProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;

    public SimplifiedLRDProcessor(DataStore<? extends KNNList> dataStore) {
        this.knns = dataStore;
    }

    @Override
    public Instance instantiate(Executor executor) {
        return new Instance(executor.getInstance(this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        public Instance(SharedDouble.Instance instance) {
            super(instance);
        }

        @Override
        public void map(DBIDRef dBIDRef) {
            KNNList kNNList = (KNNList)SimplifiedLRDProcessor.this.knns.get(dBIDRef);
            double d = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal(doubleDBIDListIter, dBIDRef)) {
                    d += doubleDBIDListIter.doubleValue();
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            this.output.set(d > 0.0 ? (double)n / d : 0.0);
        }
    }
}

