/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProxyView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;

@Title(value="GLS-Backward Search")
@Reference(authors="F. Chen and C.-T. Lu and A. P. Boedihardjo", title="GLS-SOD: A Generalized Local Statistical Approach for Spatial Outlier Detection", booktitle="Proc. 16th ACM SIGKDD international conference on Knowledge discovery and data mining", url="http://dx.doi.org/10.1145/1835804.1835939")
public class CTLuGLSBackwardSearchAlgorithm<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(CTLuGLSBackwardSearchAlgorithm.class);
    private double alpha;
    private int k;

    public CTLuGLSBackwardSearchAlgorithm(DistanceFunction<? super V> distanceFunction, int n, double d) {
        super(distanceFunction);
        this.alpha = d;
        this.k = n;
    }

    public OutlierResult run(Database database, Relation<V> relation, Relation<? extends NumberVector> relation2) {
        Object object;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax doubleMinMax = new DoubleMinMax(0.0, 0.0);
        Object object2 = DBIDUtil.newHashSet(relation.getDBIDs());
        Result result = new ProxyView<V>((DBIDs)object2, relation);
        double d = NormalDistribution.standardNormalQuantile(1.0 - this.alpha * 0.5);
        while (true) {
            object = this.singleIteration((Relation<V>)result, relation2);
            if ((Double)((Pair)object).second < d) break;
            writableDoubleDataStore.putDouble((DBIDRef)((Pair)object).first, (Double)((Pair)object).second);
            if (!Double.isNaN((Double)((Pair)object).second)) {
                doubleMinMax.put((Double)((Pair)object).second);
            }
            object2.remove((DBIDRef)((Pair)object).first);
        }
        object = object2.iter();
        while (object.valid()) {
            writableDoubleDataStore.putDouble((DBIDRef)object, 0.0);
            object.advance();
        }
        object2 = new MaterializedDoubleRelation("GLSSODBackward", "GLSSODbackward-outlier", writableDoubleDataStore, relation.getDBIDs());
        result = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult((OutlierScoreMeta)result, (DoubleRelation)object2);
    }

    private Pair<DBIDVar, Double> singleIteration(Relation<V> relation, Relation<? extends NumberVector> relation2) {
        Object object;
        int n = RelationUtil.dimensionality(relation);
        int n2 = RelationUtil.dimensionality(relation2);
        assert (n == 2);
        KNNQuery<V> kNNQuery = QueryUtil.getKNNQuery(relation, this.getDistanceFunction(), this.k + 1);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.getDBIDs());
        arrayModifiableDBIDs.sort();
        Matrix matrix = new Matrix(arrayModifiableDBIDs.size(), 6);
        Matrix matrix2 = new Matrix(arrayModifiableDBIDs.size(), arrayModifiableDBIDs.size());
        Matrix matrix3 = new Matrix(arrayModifiableDBIDs.size(), n2);
        int n3 = 0;
        Object object2 = arrayModifiableDBIDs.iter();
        while (object2.valid()) {
            object = (NumberVector)relation.get((DBIDRef)object2);
            double d = object.doubleValue(0);
            double d2 = object.doubleValue(1);
            matrix.set(n3, 0, 1.0);
            matrix.set(n3, 1, d);
            matrix.set(n3, 2, d2);
            matrix.set(n3, 3, d * d2);
            matrix.set(n3, 4, d * d);
            matrix.set(n3, 5, d2 * d2);
            object = relation2.get((DBIDRef)object2);
            for (int i = 0; i < n2; ++i) {
                double d3 = object.doubleValue(i);
                matrix3.set(n3, i, d3);
            }
            object = kNNQuery.getKNNForDBID((DBIDRef)object2, this.k + 1);
            ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray(object.size());
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            while (doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object2, doubleDBIDListIter)) {
                    arrayModifiableDBIDs2.add(doubleDBIDListIter);
                }
                doubleDBIDListIter.advance();
            }
            matrix2.set(n3, n3, 1.0);
            int n4 = -1 / arrayModifiableDBIDs2.size();
            DBIDMIter dBIDMIter = arrayModifiableDBIDs2.iter();
            while (dBIDMIter.valid()) {
                int n5 = arrayModifiableDBIDs.binarySearch(dBIDMIter);
                assert (n5 >= 0);
                matrix2.set(n5, n3, n4);
                dBIDMIter.advance();
            }
            object2.advance();
            ++n3;
        }
        Matrix matrix4 = matrix.transposeTimesTranspose(matrix2).times(matrix2);
        object2 = matrix4.times(matrix).inverse().times(matrix4.times(matrix3));
        object = matrix2.times(matrix.times((Matrix)object2).minus(matrix2.times(matrix3)));
        double d = ((Matrix)object).normF() / (double)(relation.size() - 6 - 1);
        double d4 = 1.0 / Math.sqrt(d);
        Matrix matrix5 = matrix2.times(matrix3.minus(matrix.times((Matrix)object2))).timesEquals(d4);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        double d5 = Double.NEGATIVE_INFINITY;
        int n6 = 0;
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        while (dBIDArrayMIter.valid()) {
            double d6 = matrix5.getRow(n6).squaredEuclideanLength();
            if (d6 > d5) {
                d5 = d6;
                dBIDVar.set(dBIDArrayMIter);
            }
            dBIDArrayMIter.advance();
            ++n6;
        }
        return new Pair<DBIDVar, Double>(dBIDVar, Math.sqrt(d5));
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID ALPHA_ID = new OptionID("glsbs.alpha", "Significance niveau");
        public static final OptionID K_ID = new OptionID("glsbs.k", "k nearest neighbors to use");
        private double alpha;
        private int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.getParameterAlpha(parameterization);
            this.getParameterK(parameterization);
        }

        @Override
        protected CTLuGLSBackwardSearchAlgorithm<V> makeInstance() {
            return new CTLuGLSBackwardSearchAlgorithm(this.distanceFunction, this.k, this.alpha);
        }

        protected void getParameterAlpha(Parameterization parameterization) {
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = (Double)doubleParameter.getValue();
            }
        }

        protected void getParameterK(Parameterization parameterization) {
            IntParameter intParameter = new IntParameter(K_ID);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }
    }
}

