/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="Random Walk on Exhaustive Combination")
@Description(value="Spatial Outlier Detection using Random Walk on Exhaustive Combination")
@Reference(authors="X. Liu and C.-T. Lu and F. Chen", title="Spatial outlier detection: random walk based approaches", booktitle="Proc. 18th SIGSPATIAL International Conference on Advances in Geographic Information Systems, 2010", url="http://dx.doi.org/10.1145/1869790.1869841")
public class CTLuRandomWalkEC<P>
extends AbstractDistanceBasedAlgorithm<P, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(CTLuRandomWalkEC.class);
    private double alpha;
    private double c;
    private int k;

    public CTLuRandomWalkEC(DistanceFunction<? super P> distanceFunction, double d, double d2, int n) {
        super(distanceFunction);
        this.alpha = d;
        this.c = d2;
        this.k = n;
    }

    public OutlierResult run(Relation<P> relation, Relation<? extends NumberVector> relation2) {
        double d;
        DistanceQuery<P> distanceQuery = this.getDistanceFunction().instantiate(relation);
        WritableDataStore<Vector> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 1, Vector.class);
        WritableDataStore<DBIDs> writableDataStore2 = DataStoreUtil.makeStorage(relation.getDBIDs(), 1, DBIDs.class);
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation2.getDBIDs());
        Matrix matrix = new Matrix(arrayDBIDs.size(), arrayDBIDs.size());
        KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
        int n = 0;
        Object object = arrayDBIDs.iter();
        while (object.valid()) {
            double d2 = relation2.get((DBIDRef)object).doubleValue(0);
            assert (kNNHeap.size() == 0);
            int n2 = 0;
            Object object2 = arrayDBIDs.iter();
            while (object2.valid()) {
                if (n != n2) {
                    double d3 = distanceQuery.distance((DBIDRef)object, (DBIDRef)object2);
                    kNNHeap.insert(d3, (DBIDRef)object2);
                    if (d3 == 0.0) {
                        LOG.warning("Zero distances are not supported - skipping: " + DBIDUtil.toString((DBIDRef)object) + " " + DBIDUtil.toString((DBIDRef)object2));
                        d = 0.0;
                    } else {
                        double d4 = Math.abs(d2 - relation2.get((DBIDRef)object2).doubleValue(0));
                        double d5 = Math.exp(Math.pow(d4, this.alpha));
                        d = d5 / d3;
                    }
                    matrix.set(n2, n, d);
                }
                object2.advance();
                ++n2;
            }
            object2 = DBIDUtil.newArray(kNNHeap.size());
            while (kNNHeap.size() > 0) {
                object2.add(kNNHeap.poll());
            }
            writableDataStore2.put((DBIDRef)object, (DBIDs)object2);
            object.advance();
            ++n;
        }
        for (n = 0; n < matrix.getColumnDimensionality(); ++n) {
            int n3;
            double d6 = 0.0;
            for (n3 = 0; n3 < matrix.getRowDimensionality(); ++n3) {
                d6 += matrix.get(n3, n);
            }
            if (d6 == 0.0) {
                d6 = 1.0;
            }
            for (n3 = 0; n3 < matrix.getRowDimensionality(); ++n3) {
                matrix.set(n3, n, -this.c * matrix.get(n3, n) / d6);
            }
        }
        assert (matrix.getRowDimensionality() == matrix.getColumnDimensionality());
        for (n = 0; n < matrix.getColumnDimensionality(); ++n) {
            assert (matrix.get(n, n) == 0.0);
            matrix.set(n, n, 1.0);
        }
        matrix = matrix.inverse().timesEquals(1.0 - this.c);
        n = 0;
        object = arrayDBIDs.iter();
        while (object.valid()) {
            Vector vector = matrix.getCol(n);
            writableDataStore.put((DBIDRef)object, vector);
            object.advance();
            ++n;
        }
        matrix = null;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        object = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        Object object3 = arrayDBIDs.iter();
        while (object3.valid()) {
            double d7 = 1.0;
            int n4 = 0;
            DBIDIter dBIDIter = ((DBIDs)writableDataStore2.get((DBIDRef)object3)).iter();
            while (dBIDIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object3, dBIDIter)) {
                    double d8 = MathUtil.angle((Vector)writableDataStore.get((DBIDRef)object3), (Vector)writableDataStore.get(dBIDIter));
                    d7 *= d8;
                    ++n4;
                }
                dBIDIter.advance();
            }
            d = Math.pow(d7, 1.0 / (double)n4);
            doubleMinMax.put(d);
            object.putDouble((DBIDRef)object3, d);
            object3.advance();
        }
        object3 = new MaterializedDoubleRelation("randomwalkec", "RandomWalkEC", (DoubleDataStore)object, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object3);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<N>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<N> {
        public static final OptionID K_ID = new OptionID("randomwalkec.k", "Number of nearest neighbors to use.");
        public static final OptionID ALPHA_ID = new OptionID("randomwalkec.alpha", "Scaling exponent for value differences.");
        public static final OptionID C_ID = new OptionID("randomwalkec.c", "The damping parameter c.");
        double alpha = 0.5;
        double c = 0.9;
        int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.configK(parameterization);
            this.configAlpha(parameterization);
            this.configC(parameterization);
        }

        protected void configK(Parameterization parameterization) {
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        protected void configAlpha(Parameterization parameterization) {
            DoubleParameter doubleParameter = new DoubleParameter(ALPHA_ID, 0.5);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = (Double)doubleParameter.getValue();
            }
        }

        protected void configC(Parameterization parameterization) {
            DoubleParameter doubleParameter = new DoubleParameter(C_ID);
            if (parameterization.grab(doubleParameter)) {
                this.c = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected CTLuRandomWalkEC<N> makeInstance() {
            return new CTLuRandomWalkEC(this.distanceFunction, this.alpha, this.c, this.k);
        }
    }
}

