/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjDynamicHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.LongArrayStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.OnlyOneIsAllowedToBeSetGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

@Title(value="Distance Histogram")
@Description(value="Computes a histogram over the distances occurring in the data set.")
public class DistanceStatisticsWithClasses<O>
extends AbstractDistanceBasedAlgorithm<O, CollectionResult<DoubleVector>> {
    private static final Logging LOG = Logging.getLogger(DistanceStatisticsWithClasses.class);
    protected int numbin;
    protected boolean sampling = false;
    protected boolean exact = false;

    public DistanceStatisticsWithClasses(DistanceFunction<? super O> distanceFunction, int n, boolean bl, boolean bl2) {
        super(distanceFunction);
        this.numbin = n;
        this.exact = bl;
        this.sampling = bl2;
    }

    @Override
    public HistogramResult<DoubleVector> run(Database database) {
        Object object;
        Object object3;
        AbstractObjStaticHistogram abstractObjStaticHistogram;
        Relation relation = database.getRelation(this.getInputTypeRestriction()[0], new Object[0]);
        DistanceQuery distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        StepProgress stepProgress = LOG.isVerbose() ? new StepProgress("Distance statistics", 2) : null;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        List list = ((Clustering)new ByLabelOrAllInOneClustering().run(database)).getAllClusters();
        DoubleMinMax doubleMinMax2 = new DoubleMinMax();
        DoubleMinMax doubleMinMax3 = new DoubleMinMax();
        MeanVariance meanVariance = new MeanVariance();
        MeanVariance meanVariance2 = new MeanVariance();
        MeanVariance meanVariance3 = new MeanVariance();
        MeanVariance meanVariance4 = new MeanVariance();
        MeanVariance meanVariance5 = new MeanVariance();
        MeanVariance meanVariance6 = new MeanVariance();
        LOG.beginStep(stepProgress, 1, "Prepare histogram.");
        if (this.exact) {
            doubleMinMax = this.exactMinMax(relation, distanceQuery);
            abstractObjStaticHistogram = new LongArrayStaticHistogram(this.numbin, doubleMinMax.getMin(), doubleMinMax.getMax(), 2);
        } else if (this.sampling) {
            doubleMinMax = this.sampleMinMax(relation, distanceQuery);
            abstractObjStaticHistogram = new LongArrayStaticHistogram(this.numbin, doubleMinMax.getMin(), doubleMinMax.getMax(), 2);
        } else {
            abstractObjStaticHistogram = new AbstractObjDynamicHistogram<long[]>(this.numbin){

                @Override
                protected long[] downsample(Object[] objectArray, int n, int n2, int n3) {
                    long[] lArray = new long[2];
                    for (int i = n; i < n2; ++i) {
                        long[] lArray2 = (long[])objectArray[i];
                        if (lArray2 == null) continue;
                        for (int j = 0; j < 2; ++j) {
                            int n4 = j;
                            lArray[n4] = lArray[n4] + lArray2[j];
                        }
                    }
                    return lArray;
                }

                @Override
                protected long[] aggregate(long[] lArray, long[] lArray2) {
                    for (int i = 0; i < 2; ++i) {
                        int n = i;
                        lArray[n] = lArray[n] + lArray2[i];
                    }
                    return lArray;
                }

                @Override
                protected long[] cloneForCache(long[] lArray) {
                    return (long[])lArray.clone();
                }

                @Override
                protected long[] makeObject() {
                    return new long[2];
                }
            };
        }
        LOG.beginStep(stepProgress, 2, "Build histogram.");
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Distance computations", relation.size(), LOG) : null;
        long[] lArray = new long[]{1L, 0L};
        long[] lArray2 = new long[]{0L, 1L};
        for (Cluster cluster : list) {
            DBIDIter dBIDIter = cluster.getIDs().iter();
            while (dBIDIter.valid()) {
                DoubleMinMax doubleMinMax4 = new DoubleMinMax();
                object3 = cluster.getIDs().iter();
                while (object3.valid()) {
                    if (!DBIDUtil.equal(dBIDIter, (DBIDRef)object3)) {
                        double d = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)object3);
                        abstractObjStaticHistogram.putData(d, lArray);
                        doubleMinMax4.put(d);
                    }
                    object3.advance();
                }
                meanVariance.put(doubleMinMax4.getMin());
                meanVariance2.put(doubleMinMax4.getMax());
                meanVariance3.put(doubleMinMax4.getDiff());
                doubleMinMax2.put(doubleMinMax4.getMin());
                doubleMinMax2.put(doubleMinMax4.getMax());
                object3 = new DoubleMinMax();
                for (Cluster object22 : list) {
                    if (object22 == cluster) continue;
                    object = object22.getIDs().iter();
                    while (object.valid()) {
                        if (!DBIDUtil.equal(dBIDIter, (DBIDRef)object)) {
                            double lArray3 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)object);
                            abstractObjStaticHistogram.putData(lArray3, lArray2);
                            ((DoubleMinMax)object3).put(lArray3);
                        }
                        object.advance();
                    }
                }
                meanVariance4.put(((DoubleMinMax)object3).getMin());
                meanVariance5.put(((DoubleMinMax)object3).getMax());
                meanVariance6.put(((DoubleMinMax)object3).getDiff());
                doubleMinMax3.put(((DoubleMinMax)object3).getMin());
                doubleMinMax3.put(((DoubleMinMax)object3).getMax());
                LOG.incrementProcessed(finiteProgress);
                dBIDIter.advance();
            }
        }
        LOG.ensureCompleted(finiteProgress);
        doubleMinMax.put(doubleMinMax3);
        LOG.setCompleted(stepProgress);
        long l = 0L;
        long l2 = 0L;
        object3 = abstractObjStaticHistogram.iter();
        while (object3.valid()) {
            l += ((long[])object3.getValue())[0];
            l2 += ((long[])object3.getValue())[1];
            object3.advance();
        }
        long l3 = l + l2;
        ArrayList<DoubleVector> arrayList = new ArrayList<DoubleVector>(this.numbin);
        object = abstractObjStaticHistogram.iter();
        while (object.valid()) {
            long[] lArray3 = (long[])object.getValue();
            double d = l == 0L ? 0.0 : (double)lArray3[0] / (double)l / abstractObjStaticHistogram.getBinsize();
            double d2 = (double)lArray3[0] / (double)l3 / abstractObjStaticHistogram.getBinsize();
            double d3 = l2 == 0L ? 0.0 : (double)lArray3[1] / (double)l2 / abstractObjStaticHistogram.getBinsize();
            double d4 = (double)lArray3[1] / (double)l3 / abstractObjStaticHistogram.getBinsize();
            DoubleVector doubleVector = new DoubleVector(new double[]{object.getCenter(), d, d2, d3, d4});
            arrayList.add(doubleVector);
            object.advance();
        }
        object = new HistogramResult("Distance Histogram", "distance-histogram", arrayList);
        ((CollectionResult)object).addHeader("Absolute minimum distance (abs): " + doubleMinMax.getMin());
        ((CollectionResult)object).addHeader("Absolute maximum distance (abs): " + doubleMinMax.getMax());
        ((CollectionResult)object).addHeader("In-Cluster minimum distance (abs, avg, stddev): " + doubleMinMax2.getMin() + " " + meanVariance.getMean() + " " + meanVariance.getSampleStddev());
        ((CollectionResult)object).addHeader("In-Cluster maximum distance (abs, avg, stddev): " + doubleMinMax2.getMax() + " " + meanVariance2.getMean() + " " + meanVariance2.getSampleStddev());
        ((CollectionResult)object).addHeader("Other-Cluster minimum distance (abs, avg, stddev): " + doubleMinMax3.getMin() + " " + meanVariance4.getMean() + " " + meanVariance4.getSampleStddev());
        ((CollectionResult)object).addHeader("Other-Cluster maximum distance (abs, avg, stddev): " + doubleMinMax3.getMax() + " " + meanVariance5.getMean() + " " + meanVariance5.getSampleStddev());
        ((CollectionResult)object).addHeader("Column description: bin center, in-cluster only frequency, in-cluster all frequency, other-cluster only frequency, other cluster all frequency");
        ((CollectionResult)object).addHeader("In-cluster value count: " + l + " other cluster value count: " + l2);
        return object;
    }

    private DoubleMinMax sampleMinMax(Relation<O> relation, DistanceQuery<O> distanceQuery) {
        int n = relation.size();
        Random random = new Random();
        int n2 = (int)Math.max(25.0, Math.pow(relation.size(), 0.2));
        TreeSet<DoubleDBIDPair> treeSet = new TreeSet<DoubleDBIDPair>();
        TreeSet<DoubleDBIDPair> treeSet2 = new TreeSet<DoubleDBIDPair>(Collections.reverseOrder());
        int n3 = (int)Math.max(25.0, Math.pow(relation.size(), 0.2));
        double d = (double)n3 / (double)n;
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n3);
        DBIDIter dBIDIter = relation.iterDBIDs();
        if (!dBIDIter.valid()) {
            throw new IllegalStateException("database empty: must contain elements");
        }
        DBID dBID = DBIDUtil.deref(dBIDIter);
        dBIDIter.advance();
        treeSet.add(DBIDUtil.newPair(Double.MAX_VALUE, (DBIDRef)dBID));
        treeSet2.add(DBIDUtil.newPair(Double.MIN_VALUE, (DBIDRef)dBID));
        while (dBIDIter.valid()) {
            ArrayList<DoubleDBIDPair> arrayList = new ArrayList<DoubleDBIDPair>(n2 * 2 + n3 * 2);
            for (DoubleDBIDPair d3 : treeSet) {
                if (DBIDUtil.equal(dBIDIter, d3)) continue;
                double d5 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)d3);
                arrayList.add(DBIDUtil.newPair(d5, (DBIDRef)dBIDIter));
                arrayList.add(DBIDUtil.newPair(d5, (DBIDRef)d3));
            }
            ArrayList<DoubleDBIDPair> arrayList2 = arrayModifiableDBIDs.iter();
            while (arrayList2.valid()) {
                double d2 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)((Object)arrayList2));
                arrayList.add(DBIDUtil.newPair(d2, (DBIDRef)dBIDIter));
                arrayList.add(DBIDUtil.newPair(d2, (DBIDRef)((Object)arrayList2)));
                arrayList2.advance();
            }
            treeSet.addAll(arrayList);
            DistanceStatisticsWithClasses.shrinkHeap(treeSet, n2);
            arrayList2 = new ArrayList<DoubleDBIDPair>(n2 * 2 + n3 * 2);
            for (DoubleDBIDPair doubleDBIDPair : treeSet) {
                if (DBIDUtil.equal(dBIDIter, doubleDBIDPair)) continue;
                double d3 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)doubleDBIDPair);
                arrayList2.add(DBIDUtil.newPair(d3, (DBIDRef)dBIDIter));
                arrayList2.add(DBIDUtil.newPair(d3, (DBIDRef)doubleDBIDPair));
            }
            DBIDArrayMIter object2 = arrayModifiableDBIDs.iter();
            while (object2.valid()) {
                double d4 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)object2);
                arrayList.add(DBIDUtil.newPair(d4, (DBIDRef)dBIDIter));
                arrayList.add(DBIDUtil.newPair(d4, (DBIDRef)object2));
                object2.advance();
            }
            treeSet2.addAll(arrayList2);
            DistanceStatisticsWithClasses.shrinkHeap(treeSet2, n2);
            if (arrayModifiableDBIDs.size() < n3) {
                arrayModifiableDBIDs.add(dBIDIter);
            } else if (random.nextDouble() < d) {
                arrayModifiableDBIDs.set((int)Math.floor(random.nextDouble() * (double)n3), dBIDIter);
            }
            dBIDIter.advance();
        }
        return new DoubleMinMax(((DoubleDBIDPair)treeSet.first()).doubleValue(), ((DoubleDBIDPair)treeSet2.first()).doubleValue());
    }

    private DoubleMinMax exactMinMax(Relation<O> relation, DistanceQuery<O> distanceQuery) {
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Exact fitting distance computations", relation.size(), LOG) : null;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            DBIDIter dBIDIter2 = relation.iterDBIDs();
            while (dBIDIter2.valid()) {
                if (!DBIDUtil.equal(dBIDIter, dBIDIter2)) {
                    double d = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDIter2);
                    doubleMinMax.put(d);
                }
                dBIDIter2.advance();
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        return doubleMinMax;
    }

    private static void shrinkHeap(TreeSet<DoubleDBIDPair> treeSet, int n) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(2 * n);
        int n2 = 0;
        Iterator<DoubleDBIDPair> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            DoubleDBIDPair doubleDBIDPair = iterator.next();
            if (n2 > n || hashSetModifiableDBIDs.contains(doubleDBIDPair)) {
                iterator.remove();
                continue;
            }
            hashSetModifiableDBIDs.add(doubleDBIDPair);
            ++n2;
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID EXACT_ID = new OptionID("diststat.exact", "In a first pass, compute the exact minimum and maximum, at the cost of O(2*n*n) instead of O(n*n). The number of resulting bins is guaranteed to be as requested.");
        public static final OptionID SAMPLING_ID = new OptionID("diststat.sampling", "Enable sampling of O(n) size to determine the minimum and maximum distances approximately. The resulting number of bins can be larger than the given n.");
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("diststat.bins", "Number of bins to use in the histogram. By default, it is only guaranteed to be within 1*n and 2*n of the given number.");
        protected int numbin = 20;
        protected boolean sampling = false;
        protected boolean exact = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            Flag flag2;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(HISTOGRAM_BINS_ID, 20);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.numbin = (Integer)intParameter.getValue();
            }
            if (parameterization.grab(flag2 = new Flag(EXACT_ID))) {
                this.exact = (Boolean)flag2.getValue();
            }
            if (parameterization.grab(flag = new Flag(SAMPLING_ID))) {
                this.sampling = (Boolean)flag.getValue();
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(flag2);
            arrayList.add(flag);
            parameterization.checkConstraint(new OnlyOneIsAllowedToBeSetGlobalConstraint(arrayList));
        }

        @Override
        protected DistanceStatisticsWithClasses<O> makeInstance() {
            return new DistanceStatisticsWithClasses(this.distanceFunction, this.numbin, this.exact, this.sampling);
        }
    }
}

