/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.scores.AbstractScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.ROCEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.MeanVarianceStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@Title(value="Evaluate Ranking Quality")
@Description(value="Evaluates the effectiveness of a distance function via the obtained rankings.")
public class EvaluateRankingQuality<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, CollectionResult<DoubleVector>> {
    private static final Logging LOG = Logging.getLogger(EvaluateRankingQuality.class);
    int numbins = 20;

    public EvaluateRankingQuality(DistanceFunction<? super V> distanceFunction, int n) {
        super(distanceFunction);
        this.numbins = n;
    }

    @Override
    public HistogramResult<DoubleVector> run(Database database) {
        Object object;
        ArrayList<Object> arrayList;
        Relation relation = database.getRelation(this.getInputTypeRestriction()[0], new Object[0]);
        DistanceQuery distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery kNNQuery = database.getKNNQuery(distanceQuery, relation.size());
        if (LOG.isVerbose()) {
            LOG.verbose("Preprocessing clusters...");
        }
        List list = ((Clustering)new ByLabelOrAllInOneClustering().run(database)).getAllClusters();
        HashMap<Cluster, Vector> hashMap = new HashMap<Cluster, Vector>(list.size());
        HashMap<Cluster, Matrix> hashMap2 = new HashMap<Cluster, Matrix>(list.size());
        for (Cluster object32 : list) {
            arrayList = CovarianceMatrix.make(relation, object32.getIDs());
            hashMap.put(object32, ((CovarianceMatrix)((Object)arrayList)).getMeanVector());
            hashMap2.put(object32, ((CovarianceMatrix)((Object)arrayList)).destroyToNaiveMatrix());
        }
        MeanVarianceStaticHistogram meanVarianceStaticHistogram = new MeanVarianceStaticHistogram(this.numbins, 0.0, 1.0);
        if (LOG.isVerbose()) {
            LOG.verbose("Processing points...");
        }
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing ROC AUC values", relation.size(), LOG) : null;
        for (Cluster cluster : list) {
            object = new ArrayList<DoubleDBIDPair>(cluster.size());
            Vector vector = (Vector)hashMap.get(cluster);
            Matrix matrix = (Matrix)hashMap2.get(cluster);
            DBIDIter dBIDIter = cluster.getIDs().iter();
            while (dBIDIter.valid()) {
                double d = MathUtil.mahalanobisDistance(matrix, ((NumberVector)relation.get(dBIDIter)).getColumnVector().minusEquals(vector));
                ((ArrayList)object).add(DBIDUtil.newPair(d, (DBIDRef)dBIDIter));
                dBIDIter.advance();
            }
            Collections.sort(object);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                KNNList kNNList = kNNQuery.getKNNForDBID((DBIDRef)((ArrayList)object).get(i), relation.size());
                double d = ((AbstractScoreEvaluation)new ROCEvaluation()).evaluate(cluster, (DoubleDBIDList)kNNList);
                meanVarianceStaticHistogram.put((double)i / (double)cluster.size(), d);
                LOG.incrementProcessed(finiteProgress);
            }
        }
        LOG.ensureCompleted(finiteProgress);
        arrayList = new ArrayList<Object>(relation.size());
        AbstractObjStaticHistogram.Iter iter = meanVarianceStaticHistogram.iter();
        while (iter.valid()) {
            object = new DoubleVector(new double[]{iter.getCenter(), ((MeanVariance)iter.getValue()).getCount(), ((MeanVariance)iter.getValue()).getMean(), ((MeanVariance)iter.getValue()).getSampleVariance()});
            arrayList.add(object);
            iter.advance();
        }
        return new HistogramResult<DoubleVector>("Ranking Quality Histogram", "ranking-histogram", arrayList);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID HISTOGRAM_BINS_ID = new OptionID("rankqual.bins", "Number of bins to use in the histogram");
        protected int numbins = 20;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(HISTOGRAM_BINS_ID, 20).addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.numbins = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected EvaluateRankingQuality<V> makeInstance() {
            return new EvaluateRankingQuality(this.distanceFunction, this.numbins);
        }
    }
}

