/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.cache;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.OnDiskUpperTriangleMatrix;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.io.File;
import java.io.IOException;

public class CacheDoubleDistanceInOnDiskMatrix<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(CacheDoubleDistanceInOnDiskMatrix.class);
    private static final boolean debugExtraCheckSymmetry = false;
    private InputStep input;
    private DistanceFunction<O> distance;
    private File out;

    public CacheDoubleDistanceInOnDiskMatrix(InputStep inputStep, DistanceFunction<O> distanceFunction, File file) {
        this.input = inputStep;
        this.distance = distanceFunction;
        this.out = file;
    }

    @Override
    public void run() {
        OnDiskUpperTriangleMatrix onDiskUpperTriangleMatrix;
        Database database = this.input.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery distanceQuery = database.getDistanceQuery(relation, this.distance, new Object[0]);
        DBIDRange dBIDRange = DBIDUtil.assertRange(relation.getDBIDs());
        int n = dBIDRange.size();
        try {
            onDiskUpperTriangleMatrix = new OnDiskUpperTriangleMatrix(this.out, 50902811, 0, 8, n);
        }
        catch (IOException iOException) {
            throw new AbortException("Error creating output matrix.", iOException);
        }
        DBIDArrayIter dBIDArrayIter = dBIDRange.iter();
        DBIDArrayIter dBIDArrayIter2 = dBIDRange.iter();
        while (dBIDArrayIter.valid()) {
            dBIDArrayIter2.seek(dBIDArrayIter.getOffset());
            while (dBIDArrayIter2.valid()) {
                double d = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                try {
                    onDiskUpperTriangleMatrix.getRecordBuffer(dBIDArrayIter.getOffset(), dBIDArrayIter2.getOffset()).putDouble(d);
                }
                catch (IOException iOException) {
                    throw new AbortException("Error writing distance record " + DBIDUtil.toString(dBIDArrayIter) + "," + DBIDUtil.toString(dBIDArrayIter2) + " to matrix.", iOException);
                }
                dBIDArrayIter2.advance();
            }
            dBIDArrayIter.advance();
        }
    }

    public static void main(String[] stringArray) {
        CacheDoubleDistanceInOnDiskMatrix.runCLIApplication(CacheDoubleDistanceInOnDiskMatrix.class, stringArray);
    }

    public static class Parameterizer<O>
    extends AbstractApplication.Parameterizer {
        public static final OptionID CACHE_ID = new OptionID("loader.diskcache", "File name of the disk cache to create.");
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        private InputStep input = null;
        private DistanceFunction<O> distance = null;
        private File out = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            FileParameter fileParameter;
            super.makeOptions(parameterization);
            this.input = parameterization.tryInstantiate(InputStep.class);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, DistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(fileParameter = new FileParameter(CACHE_ID, FileParameter.FileType.OUTPUT_FILE))) {
                this.out = (File)fileParameter.getValue();
            }
        }

        @Override
        protected CacheDoubleDistanceInOnDiskMatrix<O> makeInstance() {
            return new CacheDoubleDistanceInOnDiskMatrix<O>(this.input, this.distance, this.out);
        }
    }
}

