/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.cache;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class CacheDoubleDistanceKNNLists<O>
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(CacheDoubleDistanceKNNLists.class);
    private InputStep input;
    private DistanceFunction<O> distance;
    private int k;
    private File out;
    public static final int KNN_CACHE_MAGIC = -893108964;

    public CacheDoubleDistanceKNNLists(InputStep inputStep, DistanceFunction<O> distanceFunction, int n, File file) {
        this.input = inputStep;
        this.distance = distanceFunction;
        this.k = n;
        this.out = file;
    }

    @Override
    public void run() {
        Database database = this.input.getDatabase();
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery distanceQuery = database.getDistanceQuery(relation, this.distance, new Object[0]);
        KNNQuery kNNQuery = database.getKNNQuery(distanceQuery, "heavy");
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.out, "rw");
             FileChannel fileChannel = randomAccessFile.getChannel();
             FileLock fileLock = fileChannel.lock();){
            randomAccessFile.writeInt(-893108964);
            int n = this.k * 12 * 2 + 10;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing kNN", relation.size(), LOG) : null;
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.k);
                int n2 = kNNList.size();
                if (n2 * 12 + 10 > n) {
                    while (n2 * 12 + 10 > n) {
                        n <<= 1;
                    }
                    byteBuffer = ByteBuffer.allocateDirect(n);
                }
                byteBuffer.clear();
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, dBIDIter.internalGetIndex());
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, n2);
                int n3 = 0;
                DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
                while (doubleDBIDListIter.valid()) {
                    ByteArrayUtil.writeUnsignedVarint(byteBuffer, doubleDBIDListIter.internalGetIndex());
                    byteBuffer.putDouble(doubleDBIDListIter.doubleValue());
                    doubleDBIDListIter.advance();
                    ++n3;
                }
                if (n3 != kNNList.size()) {
                    throw new AbortException("Sizes did not agree. Cache is invalid.");
                }
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                LOG.incrementProcessed(finiteProgress);
                dBIDIter.advance();
            }
            LOG.ensureCompleted(finiteProgress);
            fileLock.release();
        }
        catch (IOException iOException) {
            LOG.exception(iOException);
        }
    }

    public static void main(String[] stringArray) {
        CacheDoubleDistanceKNNLists.runCLIApplication(CacheDoubleDistanceKNNLists.class, stringArray);
    }

    public static class Parameterizer<O>
    extends AbstractApplication.Parameterizer {
        public static final OptionID CACHE_ID = new OptionID("loader.diskcache", "File name of the disk cache to create.");
        public static final OptionID DISTANCE_ID = new OptionID("loader.distance", "Distance function to cache.");
        public static final OptionID K_ID = new OptionID("loader.k", "Number of nearest neighbors to precompute.");
        private InputStep input = null;
        private DistanceFunction<O> distance = null;
        private int k;
        private File out = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            FileParameter fileParameter;
            super.makeOptions(parameterization);
            this.input = parameterization.tryInstantiate(InputStep.class);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, DistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(fileParameter = new FileParameter(CACHE_ID, FileParameter.FileType.OUTPUT_FILE))) {
                this.out = (File)fileParameter.getValue();
            }
        }

        @Override
        protected CacheDoubleDistanceKNNLists<O> makeInstance() {
            return new CacheDoubleDistanceKNNLists<O>(this.input, this.distance, this.k, this.out);
        }
    }
}

