/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.synthetic.bymodel;

import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorInterface;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorInterfaceDynamic;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class GeneratorMain {
    private static final Logging LOG = Logging.getLogger(GeneratorMain.class);
    protected ArrayList<GeneratorInterface> generators = new ArrayList();
    protected boolean testAgainstModel = true;
    protected Pattern relabelClusters = null;

    public void addCluster(GeneratorInterface generatorInterface) {
        this.generators.add(generatorInterface);
    }

    public MultipleObjectsBundle generate() throws UnableToComplyException {
        if (this.generators.size() < 1) {
            throw new UnableToComplyException("No clusters specified.");
        }
        int n = this.generators.get(0).getDim();
        for (GeneratorInterface object2 : this.generators) {
            if (object2.getDim() == n) continue;
            throw new UnableToComplyException("Cluster dimensions do not agree.");
        }
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        VectorFieldTypeInformation<DoubleVector> vectorFieldTypeInformation = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, n);
        multipleObjectsBundle.appendColumn(vectorFieldTypeInformation, new ArrayList());
        multipleObjectsBundle.appendColumn(TypeUtil.CLASSLABEL, new ArrayList());
        multipleObjectsBundle.appendColumn(TypeUtil.MODEL, new ArrayList());
        ClassLabel[] classLabelArray = new ClassLabel[this.generators.size()];
        Model[] modelArray = new Model[this.generators.size()];
        this.initLabelsAndModels(this.generators, classLabelArray, modelArray, this.relabelClusters);
        for (int i = 0; i < classLabelArray.length; ++i) {
            GeneratorInterface generatorInterface = this.generators.get(i);
            GeneratorInterfaceDynamic generatorInterfaceDynamic = generatorInterface instanceof GeneratorInterfaceDynamic ? (GeneratorInterfaceDynamic)generatorInterface : null;
            boolean bl = classLabelArray[i] == null;
            int n2 = 0;
            while (n2 < generatorInterface.getSize()) {
                List<Vector> list = generatorInterface.generate(generatorInterface.getSize() - n2);
                block3: for (Vector vector : list) {
                    int n3 = i;
                    if (generatorInterfaceDynamic != null && (this.testAgainstModel || bl)) {
                        double d = generatorInterface.getDensity(vector) * (double)generatorInterface.getSize();
                        double d2 = Double.NEGATIVE_INFINITY;
                        for (int j = 0; j < this.generators.size(); ++j) {
                            if (!this.testAgainstModel && classLabelArray[j] == null) continue;
                            GeneratorInterface generatorInterface2 = this.generators.get(j);
                            double d3 = generatorInterface2.getDensity(vector) * (double)generatorInterface2.getSize();
                            if (d3 > d) {
                                generatorInterfaceDynamic.incrementDiscarded();
                                continue block3;
                            }
                            if (!bl || classLabelArray[j] == null || !(d3 > d2)) continue;
                            d2 = d3;
                            n3 = j;
                        }
                    }
                    multipleObjectsBundle.appendSimple(new DoubleVector(vector), classLabelArray[n3], modelArray[n3]);
                    ++n2;
                }
            }
        }
        return multipleObjectsBundle;
    }

    private void initLabelsAndModels(ArrayList<GeneratorInterface> arrayList, ClassLabel[] classLabelArray, Model[] modelArray, Pattern pattern) {
        GeneratorInterface generatorInterface;
        int n;
        int n2 = 0;
        if (pattern != null) {
            for (n = 0; n < classLabelArray.length; ++n) {
                generatorInterface = arrayList.get(n);
                if (pattern.matcher(generatorInterface.getName()).find()) continue;
                classLabelArray[n] = new SimpleClassLabel(generatorInterface.getName());
                modelArray[n] = generatorInterface.makeModel();
                ++n2;
            }
            if (n2 == 0) {
                LOG.warning("All clusters matched the 'reassign' pattern. Ignoring.");
            }
            if (n2 == 1) {
                for (n = 0; n < classLabelArray.length; ++n) {
                    if (classLabelArray[n] == null) continue;
                    Arrays.fill(classLabelArray, classLabelArray[n]);
                    Arrays.fill(modelArray, modelArray[n]);
                    break;
                }
            }
            if (n2 == classLabelArray.length) {
                LOG.warning("No clusters matched the 'reassign' pattern.");
            }
        }
        if (n2 == 0) {
            for (n = 0; n < classLabelArray.length; ++n) {
                generatorInterface = arrayList.get(n);
                classLabelArray[n] = new SimpleClassLabel(generatorInterface.getName());
                modelArray[n] = generatorInterface.makeModel();
            }
        }
    }

    public boolean isTestAgainstModel() {
        return this.testAgainstModel;
    }

    public void setTestAgainstModel(boolean bl) {
        this.testAgainstModel = bl;
    }

    public List<GeneratorInterface> getGenerators() {
        return Collections.unmodifiableList(this.generators);
    }

    public void setReassignPattern(Pattern pattern) {
        this.relabelClusters = pattern;
    }
}

