/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;

public class SimpleTypeInformation<T>
implements TypeInformation {
    private Class<? super T> cls;
    private String label;
    private ByteBufferSerializer<? super T> serializer;

    public SimpleTypeInformation(Class<? super T> clazz) {
        this.cls = clazz;
        this.label = null;
        this.serializer = null;
    }

    public SimpleTypeInformation(Class<? super T> clazz, String string) {
        this.cls = clazz;
        this.label = string;
        this.serializer = null;
    }

    public SimpleTypeInformation(Class<? super T> clazz, ByteBufferSerializer<? super T> byteBufferSerializer) {
        this.cls = clazz;
        this.label = null;
        this.serializer = byteBufferSerializer;
    }

    public SimpleTypeInformation(Class<? super T> clazz, String string, ByteBufferSerializer<? super T> byteBufferSerializer) {
        this.cls = clazz;
        this.label = string;
        this.serializer = byteBufferSerializer;
    }

    public final Class<? super T> getRestrictionClass() {
        return this.cls;
    }

    @Override
    public boolean isAssignableFromType(TypeInformation typeInformation) {
        if (!(typeInformation instanceof SimpleTypeInformation)) {
            return false;
        }
        SimpleTypeInformation simpleTypeInformation = (SimpleTypeInformation)typeInformation;
        return this.cls.isAssignableFrom(simpleTypeInformation.getRestrictionClass());
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.cls.isInstance(object);
    }

    public T cast(Object object) {
        return this.cls.cast(object);
    }

    public String toString() {
        return this.getRestrictionClass().getSimpleName();
    }

    public String getLabel() {
        return this.label;
    }

    public ByteBufferSerializer<? super T> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ByteBufferSerializer<? super T> byteBufferSerializer) {
        this.serializer = byteBufferSerializer;
    }
}

