/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.uncertain.WeightedDiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.AbstractDiscreteUncertainifier;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import java.util.Random;

public class WeightedDiscreteUncertainifier
extends AbstractDiscreteUncertainifier<WeightedDiscreteUncertainObject> {
    public WeightedDiscreteUncertainifier(Uncertainifier<?> uncertainifier, int n, int n2) {
        super(uncertainifier, n, n2);
    }

    @Override
    public <A> WeightedDiscreteUncertainObject newFeatureVector(Random random, A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n;
        Object UO = this.inner.newFeatureVector(random, a, numberArrayAdapter);
        int n2 = random.nextInt(this.maxQuant - this.minQuant + 1) + this.minQuant;
        DoubleVector[] doubleVectorArray = new DoubleVector[n2];
        double[] dArray = new double[n2];
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            doubleVectorArray[n] = UO.drawSample(random);
            double d2 = random.nextDouble();
            while (d2 <= 0.0) {
                d2 = random.nextDouble();
            }
            dArray[n] = d2;
            d += d2;
        }
        assert (d > 0.0);
        n = 0;
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = dArray[n3] / d;
        }
        return new WeightedDiscreteUncertainObject(doubleVectorArray, dArray);
    }

    @Override
    public FeatureVector.Factory<WeightedDiscreteUncertainObject, ?> getFactory() {
        return WeightedDiscreteUncertainObject.FACTORY;
    }

    public static class Parameterizer
    extends AbstractDiscreteUncertainifier.Parameterizer {
        @Override
        protected WeightedDiscreteUncertainifier makeInstance() {
            return new WeightedDiscreteUncertainifier(this.inner, this.minQuant, this.maxQuant);
        }
    }
}

