/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MapRecordStore
implements WritableRecordStore {
    private final int rlen;
    private final Map<DBID, Object[]> data;

    public MapRecordStore(int n, Map<DBID, Object[]> map) {
        this.rlen = n;
        this.data = map;
    }

    public MapRecordStore(int n) {
        this(n, new ConcurrentHashMap<DBID, Object[]>());
    }

    @Override
    public <T> WritableDataStore<T> getStorage(int n, Class<? super T> clazz) {
        return new StorageAccessor(n);
    }

    protected <T> T get(DBIDRef dBIDRef, int n) {
        Object[] objectArray = this.data.get(DBIDUtil.deref(dBIDRef));
        if (objectArray == null) {
            return null;
        }
        return (T)objectArray[n];
    }

    protected <T> T set(DBIDRef dBIDRef, int n, T t) {
        Object[] objectArray = this.data.get(DBIDUtil.deref(dBIDRef));
        if (objectArray == null) {
            objectArray = new Object[this.rlen];
            this.data.put(DBIDUtil.deref(dBIDRef), objectArray);
        }
        Object object = objectArray[n];
        objectArray[n] = t;
        return (T)object;
    }

    @Override
    public boolean remove(DBIDRef dBIDRef) {
        return this.data.remove(dBIDRef) != null;
    }

    protected class StorageAccessor<T>
    implements WritableDataStore<T> {
        private final int index;

        protected StorageAccessor(int n) {
            this.index = n;
        }

        @Override
        public T get(DBIDRef dBIDRef) {
            return MapRecordStore.this.get(dBIDRef, this.index);
        }

        @Override
        public T put(DBIDRef dBIDRef, T t) {
            return MapRecordStore.this.set(dBIDRef, this.index, t);
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException("Record storage accessors cannot be destroyed.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Record storage accessors cannot (yet) be cleared.");
        }

        @Override
        public void delete(DBIDRef dBIDRef) {
            throw new UnsupportedOperationException("Record storage values cannot be deleted.");
        }

        @Override
        public String getLongName() {
            return "raw";
        }

        @Override
        public String getShortName() {
            return "raw";
        }
    }
}

