/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import java.util.HashMap;
import java.util.Map;

public class MapStore<T>
implements WritableDataStore<T> {
    private Map<DBID, T> data;

    public MapStore(Map<DBID, T> map) {
        this.data = map;
    }

    public MapStore() {
        this.data = new HashMap<DBID, T>();
    }

    @Override
    public T get(DBIDRef dBIDRef) {
        return this.data.get(DBIDUtil.deref(dBIDRef));
    }

    @Override
    public T put(DBIDRef dBIDRef, T t) {
        if (t == null) {
            return this.data.remove(DBIDUtil.deref(dBIDRef));
        }
        return this.data.put(DBIDUtil.deref(dBIDRef), t);
    }

    @Override
    public void destroy() {
        this.data = null;
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.data.remove(dBIDRef);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }
}

