/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.application.GeneratorXMLSpec;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorInterface;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorMain;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorSingleCluster;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorStatic;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.HaltonUniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.xml.XMLNodeIterator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GeneratorXMLDatabaseConnection
extends AbstractDatabaseConnection {
    public static final String TAG_DATASET = "dataset";
    public static final String TAG_CLUSTER = "cluster";
    public static final String TAG_UNIFORM = "uniform";
    public static final String TAG_NORMAL = "normal";
    public static final String TAG_GAMMA = "gamma";
    public static final String TAG_HALTON = "halton";
    public static final String TAG_ROTATE = "rotate";
    public static final String TAG_TRANSLATE = "translate";
    public static final String TAG_CLIP = "clip";
    public static final String TAG_STATIC = "static";
    public static final String TAG_POINT = "point";
    public static final String ATTR_TEST = "test-model";
    public static final String ATTR_SEED = "random-seed";
    public static final String ATTR_DENSITY = "density-correction";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_MEAN = "mean";
    public static final String ATTR_STDDEV = "stddev";
    public static final String ATTR_K = "k";
    public static final String ATTR_THETA = "theta";
    public static final String ATTR_VECTOR = "vector";
    public static final String ATTR_AXIS1 = "axis1";
    public static final String ATTR_AXIS2 = "axis2";
    public static final String ATTR_ANGLE = "angle";
    private static final Logging LOG = Logging.getLogger(GeneratorXMLDatabaseConnection.class);
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    public static final String GENERATOR_SCHEMA_FILE = GeneratorXMLSpec.class.getPackage().getName().replace('.', '/') + '/' + "GeneratorByModel.xsd";
    File specfile;
    double sizescale = 1.0;
    Pattern reassign = null;
    private Random clusterRandom = null;
    private Boolean testAgainstModel;

    public GeneratorXMLDatabaseConnection(List<ObjectFilter> list, File file, double d, Pattern pattern, RandomFactory randomFactory) {
        super(list);
        this.specfile = file;
        this.sizescale = d;
        this.reassign = pattern;
        this.clusterRandom = randomFactory.getSingleThreadedRandom();
    }

    @Override
    public MultipleObjectsBundle loadData() {
        GeneratorMain generatorMain;
        if (LOG.isVerbose()) {
            LOG.verbose("Loading specification ...");
        }
        try {
            generatorMain = this.loadXMLSpecification();
        }
        catch (UnableToComplyException unableToComplyException) {
            throw new AbortException("Cannot load XML specification", unableToComplyException);
        }
        if (this.testAgainstModel != null) {
            generatorMain.setTestAgainstModel(this.testAgainstModel);
        }
        generatorMain.setReassignPattern(this.reassign);
        if (LOG.isVerbose()) {
            LOG.verbose("Generating clusters ...");
        }
        try {
            return super.invokeBundleFilters(generatorMain.generate());
        }
        catch (UnableToComplyException unableToComplyException) {
            throw new AbortException("Data generation failed. ", unableToComplyException);
        }
    }

    private GeneratorMain loadXMLSpecification() throws UnableToComplyException {
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            URL uRL = ClassLoader.getSystemResource(GENERATOR_SCHEMA_FILE);
            if (uRL != null) {
                try {
                    object = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(uRL);
                    documentBuilderFactory.setSchema((Schema)object);
                    documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                }
                catch (Exception exception) {
                    LOG.warning("Could not set up XML Schema validation for speciciation file.", exception);
                }
            } else {
                LOG.warning("Could not set up XML Schema validation for speciciation file.");
            }
            object = documentBuilderFactory.newDocumentBuilder().parse(this.specfile);
            Element element = object.getDocumentElement();
            if (TAG_DATASET.equals(element.getNodeName())) {
                GeneratorMain generatorMain = new GeneratorMain();
                this.processElementDataset(generatorMain, element);
                return generatorMain;
            }
            throw new UnableToComplyException("Experiment specification has incorrect document element: " + element.getNodeName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UnableToComplyException("Can't open specification file.", fileNotFoundException);
        }
        catch (SAXException sAXException) {
            throw new UnableToComplyException("Error parsing specification file.", sAXException);
        }
        catch (IOException iOException) {
            throw new UnableToComplyException("IO Exception loading specification file.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UnableToComplyException("Parser Configuration Error", parserConfigurationException);
        }
    }

    private void processElementDataset(GeneratorMain generatorMain, Node node) throws UnableToComplyException {
        String string;
        String string2 = ((Element)node).getAttribute(ATTR_SEED);
        if (string2 != null && string2.length() > 0) {
            this.clusterRandom = new Random((int)((double)Integer.parseInt(string2) * this.sizescale));
        }
        if ((string = ((Element)node).getAttribute(ATTR_TEST)) != null && string.length() > 0) {
            this.testAgainstModel = Integer.parseInt(string) != 0;
        }
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (TAG_CLUSTER.equals(node2.getNodeName())) {
                this.processElementCluster(generatorMain, node2);
                continue;
            }
            if (TAG_STATIC.equals(node2.getNodeName())) {
                this.processElementStatic(generatorMain, node2);
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementCluster(GeneratorMain generatorMain, Node node) throws UnableToComplyException {
        int n = -1;
        double d = 1.0;
        String string = ((Element)node).getAttribute(ATTR_SIZE);
        if (string != null && string.length() > 0) {
            n = (int)((double)Integer.parseInt(string) * this.sizescale);
        }
        String string2 = ((Element)node).getAttribute(ATTR_NAME);
        String string3 = ((Element)node).getAttribute(ATTR_DENSITY);
        if (string3 != null && string3.length() > 0) {
            d = FormatUtil.parseDouble(string3);
        }
        if (n < 0) {
            throw new UnableToComplyException("No valid cluster size given in specification file.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new UnableToComplyException("No cluster name given in specification file.");
        }
        Random random = new Random(this.clusterRandom.nextLong());
        GeneratorSingleCluster generatorSingleCluster = new GeneratorSingleCluster(string2, n, d, random);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (TAG_UNIFORM.equals(node2.getNodeName())) {
                this.processElementUniform(generatorSingleCluster, node2);
                continue;
            }
            if (TAG_NORMAL.equals(node2.getNodeName())) {
                this.processElementNormal(generatorSingleCluster, node2);
                continue;
            }
            if (TAG_GAMMA.equals(node2.getNodeName())) {
                this.processElementGamma(generatorSingleCluster, node2);
                continue;
            }
            if (TAG_HALTON.equals(node2.getNodeName())) {
                this.processElementHalton(generatorSingleCluster, node2);
                continue;
            }
            if (TAG_ROTATE.equals(node2.getNodeName())) {
                this.processElementRotate(generatorSingleCluster, node2);
                continue;
            }
            if (TAG_TRANSLATE.equals(node2.getNodeName())) {
                this.processElementTranslate(generatorSingleCluster, node2);
                continue;
            }
            if (TAG_CLIP.equals(node2.getNodeName())) {
                this.processElementClipping(generatorSingleCluster, node2);
                continue;
            }
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
        generatorMain.addCluster(generatorSingleCluster);
    }

    private void processElementUniform(GeneratorSingleCluster generatorSingleCluster, Node node) throws UnableToComplyException {
        String string;
        double d = 0.0;
        double d2 = 1.0;
        String string2 = ((Element)node).getAttribute(ATTR_MIN);
        if (string2 != null && string2.length() > 0) {
            d = FormatUtil.parseDouble(string2);
        }
        if ((string = ((Element)node).getAttribute(ATTR_MAX)) != null && string.length() > 0) {
            d2 = FormatUtil.parseDouble(string);
        }
        Random random = generatorSingleCluster.getNewRandomGenerator();
        UniformDistribution uniformDistribution = new UniformDistribution(d, d2, random);
        generatorSingleCluster.addGenerator(uniformDistribution);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementNormal(GeneratorSingleCluster generatorSingleCluster, Node node) throws UnableToComplyException {
        String string;
        double d = 0.0;
        double d2 = 1.0;
        String string2 = ((Element)node).getAttribute(ATTR_MEAN);
        if (string2 != null && string2.length() > 0) {
            d = FormatUtil.parseDouble(string2);
        }
        if ((string = ((Element)node).getAttribute(ATTR_STDDEV)) != null && string.length() > 0) {
            d2 = FormatUtil.parseDouble(string);
        }
        Random random = generatorSingleCluster.getNewRandomGenerator();
        NormalDistribution normalDistribution = new NormalDistribution(d, d2, random);
        generatorSingleCluster.addGenerator(normalDistribution);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementGamma(GeneratorSingleCluster generatorSingleCluster, Node node) throws UnableToComplyException {
        String string;
        double d = 1.0;
        double d2 = 1.0;
        String string2 = ((Element)node).getAttribute(ATTR_K);
        if (string2 != null && string2.length() > 0) {
            d = FormatUtil.parseDouble(string2);
        }
        if ((string = ((Element)node).getAttribute(ATTR_THETA)) != null && string.length() > 0) {
            d2 = FormatUtil.parseDouble(string);
        }
        Random random = generatorSingleCluster.getNewRandomGenerator();
        GammaDistribution gammaDistribution = new GammaDistribution(d, d2, random);
        generatorSingleCluster.addGenerator(gammaDistribution);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementHalton(GeneratorSingleCluster generatorSingleCluster, Node node) throws UnableToComplyException {
        String string;
        double d = 0.0;
        double d2 = 1.0;
        String string2 = ((Element)node).getAttribute(ATTR_MIN);
        if (string2 != null && string2.length() > 0) {
            d = FormatUtil.parseDouble(string2);
        }
        if ((string = ((Element)node).getAttribute(ATTR_MAX)) != null && string.length() > 0) {
            d2 = FormatUtil.parseDouble(string);
        }
        Random random = generatorSingleCluster.getNewRandomGenerator();
        HaltonUniformDistribution haltonUniformDistribution = new HaltonUniformDistribution(d, d2, random);
        generatorSingleCluster.addGenerator(haltonUniformDistribution);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementRotate(GeneratorSingleCluster generatorSingleCluster, Node node) throws UnableToComplyException {
        String string;
        String string2;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        String string3 = ((Element)node).getAttribute(ATTR_AXIS1);
        if (string3 != null && string3.length() > 0) {
            n = Integer.parseInt(string3);
        }
        if ((string2 = ((Element)node).getAttribute(ATTR_AXIS2)) != null && string2.length() > 0) {
            n2 = Integer.parseInt(string2);
        }
        if ((string = ((Element)node).getAttribute(ATTR_ANGLE)) != null && string.length() > 0) {
            d = FormatUtil.parseDouble(string);
        }
        if (n <= 0 || n > generatorSingleCluster.getDim()) {
            throw new UnableToComplyException("Invalid axis1 number given in specification file.");
        }
        if (n2 <= 0 || n2 > generatorSingleCluster.getDim()) {
            throw new UnableToComplyException("Invalid axis2 number given in specification file.");
        }
        if (n == n2) {
            throw new UnableToComplyException("Invalid axis numbers given in specification file.");
        }
        generatorSingleCluster.addRotation(n - 1, n2 - 1, Math.toRadians(d));
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementTranslate(GeneratorSingleCluster generatorSingleCluster, Node node) throws UnableToComplyException {
        Vector vector = null;
        String string = ((Element)node).getAttribute(ATTR_VECTOR);
        if (string != null && string.length() > 0) {
            vector = this.parseVector(string);
        }
        if (vector == null) {
            throw new UnableToComplyException("No translation vector given.");
        }
        generatorSingleCluster.addTranslation(vector);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementClipping(GeneratorSingleCluster generatorSingleCluster, Node node) throws UnableToComplyException {
        String string;
        Vector vector = null;
        Vector vector2 = null;
        String string2 = ((Element)node).getAttribute(ATTR_MIN);
        if (string2 != null && string2.length() > 0) {
            vector = this.parseVector(string2);
        }
        if ((string = ((Element)node).getAttribute(ATTR_MAX)) != null && string.length() > 0) {
            vector2 = this.parseVector(string);
        }
        if (vector == null || vector2 == null) {
            throw new UnableToComplyException("No or incomplete clipping vectors given.");
        }
        generatorSingleCluster.setClipping(vector, vector2);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private void processElementStatic(GeneratorMain generatorMain, Node node) throws UnableToComplyException {
        Object object;
        String string = ((Element)node).getAttribute(ATTR_NAME);
        if (string == null) {
            throw new UnableToComplyException("No cluster name given in specification file.");
        }
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            object = xMLNodeIterator.next();
            if (TAG_POINT.equals(object.getNodeName())) {
                this.processElementPoint(arrayList, (Node)object);
                continue;
            }
            if (object.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + object.getNodeName());
        }
        object = new GeneratorStatic(string, arrayList);
        generatorMain.addCluster((GeneratorInterface)object);
        if (LOG.isVerbose()) {
            LOG.verbose("Loaded cluster " + ((GeneratorStatic)object).name + " from specification.");
        }
    }

    private void processElementPoint(List<Vector> list, Node node) throws UnableToComplyException {
        Vector vector = null;
        String string = ((Element)node).getAttribute(ATTR_VECTOR);
        if (string != null && string.length() > 0) {
            vector = this.parseVector(string);
        }
        if (vector == null) {
            throw new UnableToComplyException("No translation vector given.");
        }
        list.add(vector);
        XMLNodeIterator xMLNodeIterator = new XMLNodeIterator(node.getFirstChild());
        while (xMLNodeIterator.hasNext()) {
            Node node2 = xMLNodeIterator.next();
            if (node2.getNodeType() != 1) continue;
            LOG.warning("Unknown element in XML specification file: " + node2.getNodeName());
        }
    }

    private Vector parseVector(String string) throws UnableToComplyException {
        String[] stringArray = WHITESPACE_PATTERN.split(string);
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                dArray[i] = FormatUtil.parseDouble(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnableToComplyException("Could not parse vector.");
            }
        }
        return new Vector(dArray);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID CONFIGFILE_ID = new OptionID("bymodel.spec", "The generator specification file.");
        public static final OptionID SIZE_SCALE_ID = new OptionID("bymodel.sizescale", "Factor for scaling the specified cluster sizes.");
        public static final OptionID REASSIGN_ID = new OptionID("bymodel.reassign", "Pattern to specify clusters to reassign.");
        public static final OptionID RANDOMSEED_ID = new OptionID("bymodel.randomseed", "The random generator seed.");
        File specfile = null;
        double sizescale = 1.0;
        Pattern reassign = null;
        private RandomFactory clusterRandom;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            PatternParameter patternParameter;
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            FileParameter fileParameter = new FileParameter(CONFIGFILE_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.specfile = (File)fileParameter.getValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SIZE_SCALE_ID, 1.0))) {
                this.sizescale = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(patternParameter = (PatternParameter)new PatternParameter(REASSIGN_ID).setOptional(true))) {
                this.reassign = (Pattern)patternParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOMSEED_ID))) {
                this.clusterRandom = (RandomFactory)randomParameter.getValue();
            }
            super.configFilters(parameterization);
        }

        @Override
        protected GeneratorXMLDatabaseConnection makeInstance() {
            return new GeneratorXMLDatabaseConnection(this.filters, this.specfile, this.sizescale, this.reassign, this.clusterRandom);
        }
    }
}

