/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.ExternalIDJoinDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;

public class LabelJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(LabelJoinDatabaseConnection.class);
    protected final List<DatabaseConnection> sources;

    public LabelJoinDatabaseConnection(List<ObjectFilter> list, List<DatabaseConnection> list2) {
        super(list);
        this.sources = list2;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        int n;
        Object object;
        int n2;
        int n3;
        DatabaseConnection databaseConnection2;
        ArrayList<MultipleObjectsBundle> arrayList = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection databaseConnection2 : this.sources) {
            arrayList.add(databaseConnection2.loadData());
        }
        MultipleObjectsBundle multipleObjectsBundle = (MultipleObjectsBundle)arrayList.get(0);
        databaseConnection2 = new TObjectIntHashMap(multipleObjectsBundle.dataLength(), 0.5f, -1);
        int n4 = FilterUtil.findLabelColumn(multipleObjectsBundle);
        if (n4 == -1) {
            throw new AbortException("No label column found in first source, cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
        }
        for (n3 = 0; n3 < multipleObjectsBundle.dataLength(); ++n3) {
            Object object2 = multipleObjectsBundle.data(n3, n4);
            if (object2 == null) {
                LOG.warning("Object without label encountered.");
                continue;
            }
            if (object2 instanceof String) {
                int n5 = databaseConnection2.put((String)object2, n3);
                if (n5 == -1) continue;
                LOG.warning("Duplicate label encountered: " + object2 + " in rows " + n5 + " and " + n3);
                continue;
            }
            if (object2 instanceof LabelList) {
                LabelList labelList = (LabelList)object2;
                for (n2 = 0; n2 < labelList.size(); ++n2) {
                    object = labelList.get(n2);
                    n = databaseConnection2.put(object, n3);
                    if (n == -1) continue;
                    LOG.warning("Duplicate label encountered: " + (String)object + " in rows " + n + " and " + n3);
                }
                continue;
            }
            String string = object2.toString();
            n2 = databaseConnection2.put(string, n3);
            if (n2 == -1) continue;
            LOG.warning("Duplicate label encountered: " + string + " in rows " + n2 + " and " + n3);
        }
        for (n4 = 1; n4 < this.sources.size(); ++n4) {
            MultipleObjectsBundle multipleObjectsBundle2 = (MultipleObjectsBundle)arrayList.get(n4);
            int n6 = FilterUtil.findLabelColumn(multipleObjectsBundle2);
            if (n6 == -1) {
                throw new AbortException("No label column found in source " + (n4 + 1) + ", cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>(multipleObjectsBundle2.metaLength());
            for (n2 = 0; n2 < multipleObjectsBundle2.metaLength(); ++n2) {
                if (n2 == n6) {
                    arrayList2.add(null);
                    continue;
                }
                object = new ArrayList(multipleObjectsBundle.dataLength());
                for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
                    ((ArrayList)object).add(null);
                }
                multipleObjectsBundle.appendColumn(multipleObjectsBundle2.meta(n2), (List<?>)object);
                arrayList2.add(object);
            }
            for (n2 = 0; n2 < multipleObjectsBundle2.dataLength(); ++n2) {
                object = multipleObjectsBundle2.data(n2, n6);
                if (object == null) {
                    LOG.warning("Object without label encountered.");
                    continue;
                }
                n = -1;
                if (object instanceof String) {
                    n = databaseConnection2.get(object);
                } else if (object instanceof LabelList) {
                    LabelList labelList = (LabelList)object;
                    for (int i = 0; i < labelList.size() && (n = databaseConnection2.get(labelList.get(i))) < 0; ++i) {
                    }
                } else {
                    n = databaseConnection2.get(object.toString());
                }
                if (n < 0) {
                    LOG.warning("Label not found for join: " + object + " in row " + n2);
                    continue;
                }
                for (int i = 0; i < multipleObjectsBundle2.metaLength(); ++i) {
                    if (i == n6) continue;
                    List list = (List)arrayList2.get(i);
                    assert (list != null);
                    list.set(n, multipleObjectsBundle2.data(n2, i));
                }
            }
        }
        block9: for (n4 = 0; n4 < multipleObjectsBundle.dataLength(); ++n4) {
            for (n3 = 0; n3 < multipleObjectsBundle.metaLength(); ++n3) {
                if (multipleObjectsBundle.data(n4, n3) != null) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    if (multipleObjectsBundle.data(n4, i) == null) {
                        stringBuilder.append("null");
                        continue;
                    }
                    stringBuilder.append(multipleObjectsBundle.data(n4, i));
                }
                LOG.warning("null value in joined data, row " + n4 + " column " + n3 + FormatUtil.NEWLINE + "[" + stringBuilder.toString() + "]");
                continue block9;
            }
        }
        return multipleObjectsBundle;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<DatabaseConnection> sources;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            super.configFilters(parameterization);
            ObjectListParameter objectListParameter = new ObjectListParameter(SOURCES_ID, DatabaseConnection.class);
            if (parameterization.grab(objectListParameter)) {
                this.sources = objectListParameter.instantiateClasses(parameterization);
            }
        }

        @Override
        protected LabelJoinDatabaseConnection makeInstance() {
            return new LabelJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

