/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;

@Description(value="Add uniform Jitter to a dataset, while preserving the total vector sum.")
@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.HistogramJitterFilter"})
public class HistogramJitterFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    double jitter;
    ExponentialDistribution rnd;

    public HistogramJitterFilter(double d, RandomFactory randomFactory) {
        this.jitter = d;
        this.rnd = new ExponentialDistribution(1.0, randomFactory.getSingleThreadedRandom());
    }

    @Override
    protected V filterSingleObject(V v) {
        int n = v.getDimensionality();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += v.doubleValue(i);
        }
        double d2 = 2.0 * this.jitter / (double)n * d;
        double[] dArray = new double[n];
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.rnd.nextRandom() * d2;
            d3 += dArray[i];
        }
        double d4 = d3 / d;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray[i] + (1.0 - d4) * v.doubleValue(i);
        }
        return this.factory.newNumberVector(dArray);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    protected SimpleTypeInformation<V> convertedType(SimpleTypeInformation<V> simpleTypeInformation) {
        this.initializeOutputType(simpleTypeInformation);
        return simpleTypeInformation;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID JITTER_ID = new OptionID("jitter.amount", "Jitter amount relative to data.");
        public static final OptionID SEED_ID = new OptionID("jitter.seed", "Jitter random seed.");
        double jitter = 0.1;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(JITTER_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.jitter = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected HistogramJitterFilter<DoubleVector> makeInstance() {
            return new HistogramJitterFilter<DoubleVector>(this.jitter, this.rnd);
        }
    }
}

