/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractStreamConversionFilter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class ProjectionFilter<I, O>
extends AbstractStreamConversionFilter<I, O> {
    Projection<I, O> projection;

    public ProjectionFilter(Projection<I, O> projection) {
        this.projection = projection;
    }

    @Override
    protected O filterSingleObject(I i) {
        return this.projection.project(i);
    }

    @Override
    protected TypeInformation getInputTypeRestriction() {
        return this.projection.getInputDataTypeInformation();
    }

    @Override
    protected SimpleTypeInformation<? super O> convertedType(SimpleTypeInformation<I> simpleTypeInformation) {
        this.projection.initialize(simpleTypeInformation);
        return this.projection.getOutputDataTypeInformation();
    }

    public static class Parameterizer<I, O>
    extends AbstractParameterizer {
        public static final OptionID PROJ_ID = new OptionID("projection", "Projection to use.");
        Projection<I, O> projection;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(PROJ_ID, Projection.class);
            if (parameterization.grab(objectParameter)) {
                this.projection = (Projection)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected ProjectionFilter<I, O> makeInstance() {
            return new ProjectionFilter<I, O>(this.projection);
        }
    }
}

