/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractConversionFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.Alias;

@Alias(value={"de.lmu.ifi.dbs.elki.datasource.filter.SparseVectorFieldFilter"})
public class SparseVectorFieldFilter<V extends SparseNumberVector>
extends AbstractConversionFilter<V, V> {
    private static final Logging LOG = Logging.getLogger(SparseVectorFieldFilter.class);
    int maxdim = -1;

    @Override
    protected boolean prepareStart(SimpleTypeInformation<V> simpleTypeInformation) {
        return true;
    }

    @Override
    protected void prepareProcessInstance(V v) {
        this.maxdim = Math.max(this.maxdim, v.getDimensionality());
    }

    @Override
    protected V filterSingleObject(V v) {
        assert (this.maxdim > 0);
        v.setDimensionality(this.maxdim);
        return v;
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.SPARSE_VECTOR_VARIABLE_LENGTH;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> simpleTypeInformation) {
        SparseNumberVector.Factory factory = (SparseNumberVector.Factory)FilterUtil.guessFactory(simpleTypeInformation);
        return new VectorFieldTypeInformation(factory, this.maxdim);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

