/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.WeightedDiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class WeightedUncertainSplitFilter
extends AbstractConversionFilter<NumberVector, WeightedDiscreteUncertainObject> {
    private static final Logging LOG = Logging.getLogger(WeightedUncertainSplitFilter.class);
    protected int dims;
    protected int mod;
    protected int probcol;

    public WeightedUncertainSplitFilter(int n, int n2) {
        this.dims = n;
        if (n2 < -n || n2 >= n) {
            throw new AbortException("Invalid column given for prob: " + n2);
        }
        if (n2 < 0) {
            n2 += n;
        }
        this.probcol = n2;
        this.mod = n + 1;
    }

    @Override
    protected WeightedDiscreteUncertainObject filterSingleObject(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        if (n % this.mod != 0) {
            throw new AbortException("Vector length " + n + " not divisible by the number of dimensions + 1 (for probability): " + this.mod);
        }
        int n2 = n / this.mod;
        DoubleVector[] doubleVectorArray = new DoubleVector[n2];
        double[] dArray = new double[this.dims];
        double[] dArray2 = new double[this.dims];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.mod; ++i) {
            if (n5++ == this.probcol) {
                dArray[n4] = numberVector.doubleValue(i);
            } else {
                dArray2[n3++] = numberVector.doubleValue(i);
            }
            if (n5 != this.mod) continue;
            doubleVectorArray[n4] = new DoubleVector(dArray2);
            n3 = 0;
            n5 = 0;
            ++n4;
        }
        return new WeightedDiscreteUncertainObject(doubleVectorArray, dArray);
    }

    @Override
    protected SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<WeightedDiscreteUncertainObject> convertedType(SimpleTypeInformation<NumberVector> simpleTypeInformation) {
        int n = ((VectorFieldTypeInformation)simpleTypeInformation).getDimensionality();
        if (n % this.mod != 0) {
            throw new AbortException("Vector length " + n + " not divisible by the number of dimensions + 1 (for probability): " + this.mod);
        }
        return new VectorFieldTypeInformation<WeightedDiscreteUncertainObject>(WeightedDiscreteUncertainObject.FACTORY, n);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("uncertain.dimensionality", "Dimensionality of the data set (used for splitting).");
        public static final OptionID PROBCOL_ID = new OptionID("uncertain.probability.column", "Column in which the probability is stored, starting at 0. -1 is the last column.");
        protected int dims = 0;
        protected int probcol = Integer.MIN_VALUE;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(DIM_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            IntParameter intParameter2 = new IntParameter(PROBCOL_ID);
            if (parameterization.grab(intParameter)) {
                this.dims = intParameter.intValue();
                intParameter2.addConstraint((ParameterConstraint)new LessConstraint(intParameter.intValue()));
                intParameter2.addConstraint((ParameterConstraint)new GreaterEqualConstraint(-intParameter.intValue()));
            }
            if (parameterization.grab(intParameter2)) {
                this.probcol = intParameter2.intValue();
            }
        }

        @Override
        protected WeightedUncertainSplitFilter makeInstance() {
            return new WeightedUncertainSplitFilter(this.dims, this.probcol);
        }
    }
}

