/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Alias(value={"chisq"})
@Reference(authors="J. Puzicha, J.M. Buhmann, Y. Rubner, C. Tomasi", title="Empirical evaluation of dissimilarity measures for color and texture", booktitle="Proc. 7th IEEE International Conference on Computer Vision", url="http://dx.doi.org/10.1109/ICCV.1999.790412")
public class ChiSquaredDistanceFunction
extends AbstractSpatialDistanceFunction {
    public static final ChiSquaredDistanceFunction STATIC = new ChiSquaredDistanceFunction();

    @Deprecated
    public ChiSquaredDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        double d;
        int n;
        int n2;
        int n3 = numberVector.getDimensionality();
        int n4 = n3 < (n2 = numberVector2.getDimensionality()) ? n3 : n2;
        double d2 = 0.0;
        for (n = 0; n < n4; ++n) {
            d = numberVector.doubleValue(n);
            double d3 = numberVector2.doubleValue(n);
            double d4 = d - d3;
            double d5 = d + d3;
            if (!(d5 > 0.0) && !(d5 < 0.0) || !(d4 > 0.0) && !(d4 < 0.0)) continue;
            d2 += d4 * d4 / d5;
        }
        for (n = n4; n < n3; ++n) {
            d = numberVector.doubleValue(n);
            if (d != d) continue;
            d2 += d;
        }
        for (n = n4; n < n2; ++n) {
            d = numberVector2.doubleValue(n);
            if (d != d) continue;
            d2 += d;
        }
        return 2.0 * d2;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        double d;
        double d2;
        int n;
        int n2;
        int n3 = spatialComparable.getDimensionality();
        int n4 = n3 < (n2 = spatialComparable2.getDimensionality()) ? n3 : n2;
        double d3 = 0.0;
        for (n = 0; n < n4; ++n) {
            double d4;
            d2 = spatialComparable.getMin(n);
            d = spatialComparable.getMax(n);
            double d5 = spatialComparable2.getMin(n);
            double d6 = spatialComparable2.getMax(n);
            if (d < d5) {
                d4 = d5 - d;
            } else {
                if (!(d6 < d2)) continue;
                d4 = d6 - d2;
            }
            double d7 = d + d6;
            if (!(d7 > 0.0) && !(d7 < 0.0) || !(d4 > 0.0) && !(d4 < 0.0)) continue;
            d3 += d4 * d4 / d7;
        }
        for (n = n4; n < n3; ++n) {
            d2 = spatialComparable.getMin(n);
            if (d2 > 0.0) {
                d3 += d2;
                continue;
            }
            d = spatialComparable.getMax(n);
            if (!(d < 0.0)) continue;
            d3 += d;
        }
        for (n = n4; n < n2; ++n) {
            d2 = spatialComparable2.getMin(n);
            if (d2 > 0.0) {
                d3 += d2;
                continue;
            }
            d = spatialComparable2.getMax(n);
            if (!(d < 0.0)) continue;
            d3 += d;
        }
        return 2.0 * d3;
    }

    public String toString() {
        return "ChiSquaredDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    public SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ChiSquaredDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

