/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.strings;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractPrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.strings.LevenshteinDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Description(value="Levenshtein distance, normalized by average string length.")
@Reference(authors="V. I. Levenshtein", title="Binary codes capable of correcting deletions, insertions and reversals.", booktitle="Soviet physics doklady. Vol. 10. 1966.")
public class NormalizedLevenshteinDistanceFunction
extends AbstractPrimitiveDistanceFunction<String> {
    public static final NormalizedLevenshteinDistanceFunction STATIC_SENSITIVE = new NormalizedLevenshteinDistanceFunction();

    @Deprecated
    public NormalizedLevenshteinDistanceFunction() {
    }

    @Override
    public double distance(String string, String string2) {
        int n = LevenshteinDistanceFunction.levenshteinDistance(string, string2);
        return (double)n * 2.0 / (double)(string.length() + string2.length());
    }

    @Override
    public SimpleTypeInformation<? super String> getInputTypeRestriction() {
        return TypeUtil.STRING;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected NormalizedLevenshteinDistanceFunction makeInstance() {
            return STATIC_SENSITIVE;
        }
    }
}

