/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.AbstractEditDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.Arrays;

@Title(value="Dynamic Time Warping Distance Function")
@Reference(authors="Berndt, D. and Clifford, J.", title="Using dynamic time warping to find patterns in time series", booktitle="AAAI-94 Workshop on Knowledge Discovery in Databases, 1994", url="http://www.aaai.org/Papers/Workshops/1994/WS-94-03/WS94-03-031.pdf")
public class DTWDistanceFunction
extends AbstractEditDistanceFunction {
    public DTWDistanceFunction() {
        this(Double.POSITIVE_INFINITY);
    }

    public DTWDistanceFunction(double d) {
        super(d);
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = numberVector.getDimensionality();
        int n2 = numberVector2.getDimensionality();
        int n3 = n2 - 1;
        int n4 = this.effectiveBandSize(n, n2);
        if (Math.abs(n - n2) > n4) {
            return Double.POSITIVE_INFINITY;
        }
        double[] dArray = new double[n2 << 1];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        this.firstRow(dArray, n4, numberVector, numberVector2, n2);
        int n5 = 0;
        int n6 = n2;
        int n7 = 1;
        int n8 = 0;
        int n9 = Math.min(n3, n7 + n4);
        while (n7 < n) {
            double d = numberVector.doubleValue(n7);
            for (int i = n8; i <= n9; ++i) {
                double d2 = dArray[n5 + i];
                if (i > 0) {
                    double d3 = dArray[n5 + i - 1];
                    double d4 = d2 = d3 < d2 ? d3 : d2;
                    if (i > n8) {
                        double d5 = dArray[n6 + i - 1];
                        d2 = d5 < d2 ? d5 : d2;
                    }
                }
                dArray[n6 + i] = d2 + this.delta(d, numberVector2.doubleValue(i));
            }
            n5 = n2 - n5;
            n6 = n2 - n6;
            if (++n7 > n4) {
                ++n8;
            }
            if (n9 >= n3) continue;
            ++n9;
        }
        return Math.sqrt(dArray[n5 + n2 - 1]);
    }

    protected void firstRow(double[] dArray, int n, NumberVector numberVector, NumberVector numberVector2, int n2) {
        double d = numberVector.doubleValue(0);
        dArray[0] = this.delta(d, numberVector2.doubleValue(0));
        int n3 = n >= n2 ? n2 - 1 : n;
        for (int i = 1; i <= n3; ++i) {
            dArray[i] = dArray[i - 1] + this.delta(d, numberVector2.doubleValue(i));
        }
    }

    protected double delta(double d, double d2) {
        double d3 = d - d2;
        return d3 * d3;
    }

    public static class Parameterizer
    extends AbstractEditDistanceFunction.Parameterizer {
        @Override
        protected DTWDistanceFunction makeInstance() {
            return new DTWDistanceFunction(this.bandSize);
        }
    }
}

