/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="M.-M. Deza and E. Deza", title="Dictionary of distances", booktitle="Dictionary of distances")
public class Kulczynski2SimilarityFunction
extends AbstractVectorSimilarityFunction {
    public static final Kulczynski2SimilarityFunction STATIC_CONTINUOUS = new Kulczynski2SimilarityFunction();

    @Deprecated
    public Kulczynski2SimilarityFunction() {
    }

    @Override
    public double similarity(NumberVector numberVector, NumberVector numberVector2) {
        int n = AbstractNumberVectorDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = numberVector.doubleValue(i);
            double d5 = numberVector2.doubleValue(i);
            d += d4;
            d2 += d5;
            d3 += Math.min(d4, d5);
        }
        return (double)n * 0.5 * ((double)n / d + (double)n / d2) * d3;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected Kulczynski2SimilarityFunction makeInstance() {
            return STATIC_CONTINUOUS;
        }
    }
}

