/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation;

import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelClustering;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.EvaluateClustering;
import de.lmu.ifi.dbs.elki.evaluation.histogram.ComputeOutlierHistogram;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierPrecisionAtKCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierPrecisionRecallCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierROCCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierRankingEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class AutomaticEvaluation
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(AutomaticEvaluation.class);

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        this.autoEvaluateClusterings(resultHierarchy, result);
        this.autoEvaluateOutliers(resultHierarchy, result);
    }

    protected void autoEvaluateOutliers(ResultHierarchy resultHierarchy, Result result) {
        ArrayList<OutlierResult> arrayList = ResultUtil.filterResults(resultHierarchy, result, OutlierResult.class);
        if (LOG.isDebugging()) {
            LOG.debug("Number of new outlier results: " + arrayList.size());
        }
        if (arrayList.size() > 0) {
            Database database = ResultUtil.findDatabase(resultHierarchy);
            ResultUtil.ensureClusteringResult(database, database);
            ArrayList<Clustering> arrayList2 = ResultUtil.filterResults(resultHierarchy, database, Clustering.class);
            if (arrayList2.size() == 0) {
                LOG.warning("Could not find a clustering result, even after running 'ensureClusteringResult'?!?");
                return;
            }
            Clustering clustering = (Clustering)arrayList2.iterator().next();
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            String string = null;
            if (clustering.getAllClusters().size() > 1) {
                for (Cluster cluster : clustering.getAllClusters()) {
                    int n3 = cluster.getIDs().size();
                    n2 += n3;
                    if (n3 >= n) continue;
                    n = n3;
                    string = cluster.getName();
                }
            }
            if (string == null) {
                LOG.warning("Could not evaluate outlier results, as I could not find a minority label.");
                return;
            }
            if (n == 1) {
                LOG.warning("The minority class label had a single object. Try using 'ClassLabelFilter' to identify the class label column.");
            }
            if ((double)n > 0.05 * (double)n2) {
                LOG.warning("The minority class I discovered (labeled '" + string + "') has " + (double)n * 100.0 / (double)n2 + "% of objects. Outlier classes should be more rare!");
            }
            LOG.verbose("Evaluating using minority class: " + string);
            Pattern pattern = Pattern.compile("^" + Pattern.quote(string) + "$");
            new OutlierRankingEvaluation(pattern).processNewResult(resultHierarchy, result);
            new OutlierROCCurve(pattern).processNewResult(resultHierarchy, result);
            new OutlierPrecisionAtKCurve(pattern, n << 1).processNewResult(resultHierarchy, result);
            new OutlierPrecisionRecallCurve(pattern).processNewResult(resultHierarchy, result);
            new ComputeOutlierHistogram(pattern, 50, new LinearScaling(), false).processNewResult(resultHierarchy, result);
        }
    }

    protected void autoEvaluateClusterings(ResultHierarchy resultHierarchy, Result result) {
        ArrayList<Clustering> arrayList = ResultUtil.filterResults(resultHierarchy, result, Clustering.class);
        if (LOG.isDebugging()) {
            LOG.warning("Number of new clustering results: " + arrayList.size());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Clustering clustering = (Clustering)iterator.next();
            if ("allinone-clustering".equals(clustering.getShortName())) {
                iterator.remove();
                continue;
            }
            if ("allinnoise-clustering".equals(clustering.getShortName())) {
                iterator.remove();
                continue;
            }
            if ("bylabel-clustering".equals(clustering.getShortName())) {
                iterator.remove();
                continue;
            }
            if (!"bymodel-clustering".equals(clustering.getShortName())) continue;
            iterator.remove();
        }
        if (arrayList.size() > 0) {
            try {
                new EvaluateClustering(new ByLabelClustering(), false, true).processNewResult(resultHierarchy, result);
            }
            catch (NoSupportedDataTypeException noSupportedDataTypeException) {
                // empty catch block
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AutomaticEvaluation makeInstance() {
            return new AutomaticEvaluation();
        }
    }
}

