/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import java.util.List;

public class LogClusterSizes
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(LogClusterSizes.class);
    public static final String PREFIX = LogClusterSizes.class.getName() + ".";

    public static <C extends Model> void logClusterSizes(Clustering<C> clustering) {
        if (!LOG.isStatistics()) {
            return;
        }
        List<Cluster<C>> list = clustering.getAllClusters();
        int n = list.size();
        LOG.statistics(new StringStatistic(PREFIX + "name", clustering.getLongName()));
        LOG.statistics(new LongStatistic(PREFIX + "clusters", n));
        Hierarchy<Cluster<C>> hierarchy = clustering.getClusterHierarchy();
        int n2 = 0;
        for (Cluster<C> cluster : list) {
            String string = PREFIX + "cluster-" + n2 + ".";
            if (cluster.getName() != null) {
                LOG.statistics(new StringStatistic(string + "name", cluster.getName()));
            }
            LOG.statistics(new LongStatistic(string + "size", cluster.size()));
            if (cluster.isNoise()) {
                LOG.statistics(new StringStatistic(string + "noise", "true"));
            }
            if (hierarchy.numChildren(cluster) > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                Hierarchy.Iter<Cluster<C>> iter = hierarchy.iterChildren(cluster);
                while (iter.valid()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(iter.get().getName());
                    iter.advance();
                }
                LOG.statistics(new StringStatistic(string + "children", stringBuilder.toString()));
            }
            ++n2;
        }
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list == null || list.size() < 1) {
            return;
        }
        for (Clustering<? extends Model> clustering : list) {
            LogClusterSizes.logClusterSizes(clustering);
        }
    }
}

