/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering.internal;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.EvaluationResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="P. J. Rousseeuw", title="Silhouettes: A graphical aid to the interpretation and validation of cluster analysis", booktitle="Journal of Computational and Applied Mathematics, Volume 20", url="http://dx.doi.org/10.1016%2F0377-0427%2887%2990125-7")
public class EvaluateSilhouette<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(EvaluateSilhouette.class);
    private DistanceFunction<? super O> distance;
    private NoiseHandling noiseOption;
    private boolean penalize = true;
    private String key = EvaluateSilhouette.class.getName();

    public EvaluateSilhouette(DistanceFunction<? super O> distanceFunction, NoiseHandling noiseHandling, boolean bl) {
        this.distance = distanceFunction;
        this.noiseOption = noiseHandling;
        this.penalize = bl;
    }

    public EvaluateSilhouette(DistanceFunction<? super O> distanceFunction, boolean bl) {
        this(distanceFunction, bl ? NoiseHandling.MERGE_NOISE : NoiseHandling.TREAT_NOISE_AS_SINGLETONS, true);
    }

    public double evaluateClustering(Database database, Relation<O> relation, DistanceQuery<O> distanceQuery, Clustering<?> clustering) {
        List<Cluster<?>> list = clustering.getAllClusters();
        MeanVariance meanVariance = new MeanVariance();
        int n = 0;
        block8: for (Cluster<?> cluster : list) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: {
                        n += cluster.size();
                        continue block8;
                    }
                    case TREAT_NOISE_AS_SINGLETONS: {
                        meanVariance.put(0.0, cluster.size());
                        continue block8;
                    }
                }
            }
            ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(cluster.getIDs());
            double[] dArray = new double[arrayDBIDs.size()];
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
            dBIDArrayIter.seek(0);
            while (dBIDArrayIter.valid()) {
                double d;
                double d2 = dArray[dBIDArrayIter.getOffset()];
                dBIDArrayIter2.seek(dBIDArrayIter.getOffset() + 1);
                while (dBIDArrayIter2.valid()) {
                    d = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                    d2 += d;
                    int n2 = dBIDArrayIter2.getOffset();
                    dArray[n2] = dArray[n2] + d;
                    dBIDArrayIter2.advance();
                }
                d2 /= (double)(arrayDBIDs.size() - 1);
                d = Double.POSITIVE_INFINITY;
                block11: for (Cluster<?> cluster2 : list) {
                    double d3;
                    Object object;
                    if (cluster2 == cluster) continue;
                    if (cluster2.size() <= 1 || cluster2.isNoise()) {
                        switch (this.noiseOption) {
                            case IGNORE_NOISE: {
                                continue block11;
                            }
                            case TREAT_NOISE_AS_SINGLETONS: {
                                object = cluster2.getIDs().iter();
                                while (object.valid()) {
                                    d3 = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)object);
                                    d = d3 < d ? d3 : d;
                                    object.advance();
                                }
                                continue block11;
                            }
                        }
                    }
                    object = cluster2.getIDs();
                    d3 = 0.0;
                    DBIDIter dBIDIter = object.iter();
                    while (dBIDIter.valid()) {
                        d3 += distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDIter);
                        dBIDIter.advance();
                    }
                    d = (d3 /= (double)object.size()) < d ? d3 : d;
                }
                d = d < Double.POSITIVE_INFINITY ? d : d2;
                meanVariance.put((d - d2) / (d > d2 ? d : d2));
                dBIDArrayIter.advance();
            }
        }
        double d = 1.0;
        if (this.penalize && n > 0) {
            d = (double)(relation.size() - n) / (double)relation.size();
        }
        double d4 = d * meanVariance.getMean();
        double d5 = d * meanVariance.getSampleStddev();
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(this.key + ".silhouette.noise-handling", this.noiseOption.toString()));
            if (n > 0) {
                LOG.statistics(new LongStatistic(this.key + ".silhouette.noise", n));
            }
            LOG.statistics(new DoubleStatistic(this.key + ".silhouette.mean", d4));
            LOG.statistics(new DoubleStatistic(this.key + ".silhouette.stddev", d5));
        }
        EvaluationResult evaluationResult = EvaluationResult.findOrCreate(database.getHierarchy(), clustering, "Internal Clustering Evaluation", "internal evaluation");
        EvaluationResult.MeasurementGroup measurementGroup = evaluationResult.findOrCreateGroup("Distance-based Evaluation");
        measurementGroup.addMeasure("Silhouette +-" + FormatUtil.NF2.format(d5), d4, -1.0, 1.0, 0.0, false);
        database.getHierarchy().resultChanged(evaluationResult);
        return d4;
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(result);
        if (list.size() < 1) {
            return;
        }
        Database database = ResultUtil.findDatabase(resultHierarchy);
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        DistanceQuery<? super O> distanceQuery = database.getDistanceQuery(relation, this.distance, new Object[0]);
        for (Clustering<? extends Model> clustering : list) {
            this.evaluateClustering(database, relation, distanceQuery, clustering);
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID DISTANCE_ID = new OptionID("silhouette.distance", "Distance function to use for computing the silhouette.");
        public static final OptionID NOISE_ID = new OptionID("silhouette.noisehandling", "Control how noise should be treated.");
        public static final OptionID NO_PENALIZE_ID = new OptionID("silhouette.no-penalize-noise", "Do not penalize ignored noise.");
        private DistanceFunction<? super O> distance;
        private NoiseHandling noiseOption;
        private boolean penalize = true;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            EnumParameter<NoiseHandling> enumParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(DISTANCE_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distance = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(enumParameter = new EnumParameter<NoiseHandling>(NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)enumParameter.getValue());
            }
            if (this.noiseOption == NoiseHandling.IGNORE_NOISE && parameterization.grab(flag = new Flag(NO_PENALIZE_ID))) {
                this.penalize = flag.isFalse();
            }
        }

        @Override
        protected EvaluateSilhouette<O> makeInstance() {
            return new EvaluateSilhouette<O>(this.distance, this.noiseOption, this.penalize);
        }
    }
}

