/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.AbstractSingleParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.ConfiguratorPanel;
import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.gui.util.ClassTree;
import de.lmu.ifi.dbs.elki.gui.util.TreePopup;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassListParameterConfigurator
extends AbstractSingleParameterConfigurator<ClassListParameter<?>>
implements ActionListener,
ChangeListener {
    final ConfiguratorPanel child;
    final JPanel panel;
    final JTextField textfield = new JTextField();
    final JButton button;
    final TreePopup popup;

    public ClassListParameterConfigurator(ClassListParameter<?> classListParameter, JComponent jComponent) {
        super(classListParameter, jComponent);
        this.textfield.setToolTipText(((ClassListParameter)this.param).getShortDescription());
        if (classListParameter.isDefined() && !classListParameter.tookDefaultValue()) {
            this.textfield.setText(classListParameter.getValueAsString());
        }
        this.textfield.setPreferredSize(new Dimension(400, this.textfield.getPreferredSize().height));
        this.button = new JButton(StockIcon.getStockIcon("list-add"));
        this.button.setToolTipText(((ClassListParameter)this.param).getShortDescription());
        this.button.addActionListener(this);
        TreeNode treeNode = ClassTree.build(classListParameter.getKnownImplementations(), classListParameter.getRestrictionClass().getPackage().getName());
        this.popup = new TreePopup(new DefaultTreeModel(treeNode));
        this.popup.getTree().setRootVisible(false);
        this.popup.addActionListener(this);
        Icon icon = StockIcon.getStockIcon("go-next");
        Icon icon2 = StockIcon.getStockIcon("package");
        TreePopup.Renderer renderer = (TreePopup.Renderer)this.popup.getTree().getCellRenderer();
        renderer.setLeafIcon(icon);
        renderer.setFolderIcon(icon2);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.textfield, "Center");
        this.panel.add((Component)this.button, "East");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jComponent.add((Component)this.panel, gridBagConstraints);
        this.finishGridRow();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.child = new ConfiguratorPanel();
        this.child.addChangeListener(this);
        jComponent.add((Component)this.child, gridBagConstraints);
        this.textfield.addActionListener(this);
    }

    @Override
    public void addParameter(Object object, Parameter<?> parameter, TrackParameters trackParameters) {
        this.child.addParameter(object, parameter, trackParameters);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button) {
            this.popup.show(this.panel);
            return;
        }
        if (actionEvent.getSource() == this.textfield) {
            this.fireValueChanged();
            return;
        }
        if (actionEvent.getSource() == this.popup) {
            Object object;
            if (actionEvent.getActionCommand() == "canceled") {
                this.popup.setVisible(false);
                this.textfield.requestFocus();
                return;
            }
            TreePath treePath = this.popup.getTree().getSelectionPath();
            Object object2 = object = treePath != null ? treePath.getLastPathComponent() : null;
            if (object instanceof ClassTree.ClassNode) {
                String string;
                ClassTree.ClassNode classNode = treePath != null ? (ClassTree.ClassNode)object : null;
                String string2 = string = classNode != null ? classNode.getClassName() : null;
                if (string != null && string.length() > 0) {
                    String string3 = this.textfield.getText();
                    string3 = string3.length() > 0 ? string3 + "," + string : string;
                    this.textfield.setText(string3);
                    this.popup.setVisible(false);
                    this.fireValueChanged();
                }
            }
            return;
        }
        LoggingUtil.warning("actionPerformed triggered by unknown source: " + actionEvent.getSource());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.child) {
            this.fireValueChanged();
            return;
        }
        LoggingUtil.warning("stateChanged triggered by unknown source: " + changeEvent.getSource());
    }

    @Override
    public String getUserInput() {
        return this.textfield.getText();
    }

    @Override
    public void appendParameters(ListParameterization listParameterization) {
        super.appendParameters(listParameterization);
        this.child.appendParameters(listParameterization);
    }
}

