/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.gui.multistep.panels.ParameterTabPanel;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.workflow.InputStep;

public class InputTabPanel
extends ParameterTabPanel {
    private static final long serialVersionUID = 1L;
    private InputStep input = null;
    private boolean executed = false;

    @Override
    protected synchronized void configureStep(Parameterization parameterization) {
        this.input = parameterization.tryInstantiate(InputStep.class);
        if (parameterization.getErrors().size() > 0) {
            this.input = null;
        }
        this.executed = false;
    }

    @Override
    protected void executeStep() {
        this.input.getDatabase();
        this.executed = true;
    }

    public InputStep getInputStep() {
        if (this.input == null) {
            throw new AbortException("Data input not configured.");
        }
        return this.input;
    }

    @Override
    protected ParameterTabPanel.Status getStatus() {
        if (this.input == null) {
            return ParameterTabPanel.Status.STATUS_UNCONFIGURED;
        }
        if (this.executed) {
            if (this.input.getDatabase() == null) {
                return ParameterTabPanel.Status.STATUS_FAILED;
            }
            return ParameterTabPanel.Status.STATUS_COMPLETE;
        }
        return ParameterTabPanel.Status.STATUS_READY;
    }
}

