/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;

public class InMemoryLSHIndex<V>
implements IndexFactory<V, Instance> {
    private static final Logging LOG = Logging.getLogger(InMemoryLSHIndex.class);
    LocalitySensitiveHashFunctionFamily<? super V> family;
    int l;
    int numberOfBuckets;

    public InMemoryLSHIndex(LocalitySensitiveHashFunctionFamily<? super V> localitySensitiveHashFunctionFamily, int n, int n2) {
        this.family = localitySensitiveHashFunctionFamily;
        this.l = n;
        this.numberOfBuckets = n2;
    }

    @Override
    public Instance instantiate(Relation<V> relation) {
        return new Instance(relation, this.family.generateHashFunctions(relation, this.l), this.numberOfBuckets);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.family.getInputTypeRestriction();
    }

    public static class Parameterizer<V>
    extends AbstractParameterizer {
        public static final OptionID FAMILY_ID = new OptionID("lsh.family", "Hash function family to use for LSH.");
        public static final OptionID L_ID = new OptionID("lsh.tables", "Number of hash tables to use.");
        public static final OptionID BUCKETS_ID = new OptionID("lsh.buckets", "Number of hash buckets to use.");
        LocalitySensitiveHashFunctionFamily<? super V> family;
        int l;
        int numberOfBuckets;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(FAMILY_ID, LocalitySensitiveHashFunctionFamily.class);
            if (parameterization.grab(objectParameter)) {
                this.family = (LocalitySensitiveHashFunctionFamily)objectParameter.instantiateClass(parameterization);
            }
            IntParameter intParameter = new IntParameter(L_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.l = intParameter.intValue();
            }
            IntParameter intParameter2 = new IntParameter(BUCKETS_ID);
            intParameter2.setDefaultValue((Object)7919);
            intParameter2.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter2)) {
                this.numberOfBuckets = intParameter2.intValue();
            }
        }

        @Override
        protected InMemoryLSHIndex<V> makeInstance() {
            return new InMemoryLSHIndex<V>(this.family, this.l, this.numberOfBuckets);
        }
    }

    public class Instance
    extends AbstractRefiningIndex<V>
    implements KNNIndex<V>,
    RangeIndex<V> {
        ArrayList<? extends LocalitySensitiveHashFunction<? super V>> hashfunctions;
        ArrayList<TIntObjectMap<DBIDs>> hashtables;
        private int numberOfBuckets;

        public Instance(Relation<V> relation, ArrayList<? extends LocalitySensitiveHashFunction<? super V>> arrayList, int n) {
            super(relation);
            this.hashfunctions = arrayList;
            this.numberOfBuckets = n;
        }

        @Override
        public String getLongName() {
            return "LSH index";
        }

        @Override
        public String getShortName() {
            return "lsh-index";
        }

        @Override
        public void initialize() {
            TIntObjectIterator tIntObjectIterator;
            int n;
            TIntObjectMap<DBIDs> tIntObjectMap;
            int n2;
            int n3 = this.hashfunctions.size();
            this.hashtables = new ArrayList(n3);
            for (int i = 0; i < n3; ++i) {
                this.hashtables.add((TIntObjectMap<DBIDs>)new TIntObjectHashMap(this.numberOfBuckets));
            }
            double[] dArray = new double[this.hashfunctions.get(0).getNumberOfProjections()];
            FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Building LSH index", this.relation.size(), LOG) : null;
            int n4 = Math.max(2, (int)Math.ceil((double)this.relation.size() / (double)this.numberOfBuckets));
            DBIDIter dBIDIter = this.relation.getDBIDs().iter();
            while (dBIDIter.valid()) {
                Object o = this.relation.get(dBIDIter);
                for (n2 = 0; n2 < n3; ++n2) {
                    int n5;
                    tIntObjectMap = this.hashtables.get(n2);
                    DBIDs dBIDs = (DBIDs)tIntObjectMap.get(n5 = (n = (tIntObjectIterator = this.hashfunctions.get(n2)).hashObject(o, dArray)) % this.numberOfBuckets);
                    if (dBIDs == null) {
                        tIntObjectMap.put(n5, (Object)DBIDUtil.deref(dBIDIter));
                        continue;
                    }
                    if (dBIDs.size() > 1) {
                        ((ModifiableDBIDs)dBIDs).add(dBIDIter);
                        continue;
                    }
                    ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n4);
                    arrayModifiableDBIDs.addDBIDs(dBIDs);
                    arrayModifiableDBIDs.add(dBIDIter);
                    tIntObjectMap.put(n5, (Object)arrayModifiableDBIDs);
                }
                LOG.incrementProcessed(finiteProgress);
                dBIDIter.advance();
            }
            LOG.ensureCompleted(finiteProgress);
            if (LOG.isStatistics()) {
                int n6 = Integer.MAX_VALUE;
                int n7 = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    tIntObjectMap = this.hashtables.get(n2);
                    tIntObjectIterator = tIntObjectMap.iterator();
                    while (tIntObjectIterator.hasNext()) {
                        tIntObjectIterator.advance();
                        n = ((DBIDs)tIntObjectIterator.value()).size();
                        if (n < n6) {
                            n6 = n;
                        }
                        if (n <= n7) continue;
                        n7 = n;
                    }
                }
                LOG.statistics(new LongStatistic(this.getClass().getName() + ".fill.min", n6));
                LOG.statistics(new LongStatistic(this.getClass().getName() + ".fill.max", n7));
                LOG.statistics(new LongStatistic(this.getClass().getName() + ".hashtables", this.hashtables.size()));
            }
        }

        @Override
        public Logging getLogger() {
            return LOG;
        }

        @Override
        public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
            for (Object object : objectArray) {
                if (!"exact".equals(object)) continue;
                return null;
            }
            DistanceFunction distanceFunction = distanceQuery.getDistanceFunction();
            if (!InMemoryLSHIndex.this.family.isCompatible(distanceFunction)) {
                return null;
            }
            return new LSHKNNQuery(distanceQuery);
        }

        @Override
        public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
            for (Object object : objectArray) {
                if (!"exact".equals(object)) continue;
                return null;
            }
            DistanceFunction distanceFunction = distanceQuery.getDistanceFunction();
            if (!InMemoryLSHIndex.this.family.isCompatible(distanceFunction)) {
                return null;
            }
            return new LSHRangeQuery(distanceQuery);
        }

        protected class LSHRangeQuery
        extends AbstractRefiningIndex.AbstractRangeQuery {
            public LSHRangeQuery(DistanceQuery<V> distanceQuery) {
                super(distanceQuery);
            }

            @Override
            public void getRangeForObject(V v, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
                HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
                int n = Instance.this.hashtables.size();
                double[] dArray = new double[Instance.this.hashfunctions.get(0).getNumberOfProjections()];
                for (int i = 0; i < n; ++i) {
                    LocalitySensitiveHashFunction localitySensitiveHashFunction;
                    int n2;
                    int n3;
                    TIntObjectMap<DBIDs> tIntObjectMap = Instance.this.hashtables.get(i);
                    DBIDs dBIDs = (DBIDs)tIntObjectMap.get(n3 = (n2 = (localitySensitiveHashFunction = Instance.this.hashfunctions.get(i)).hashObject(v, dArray)) % Instance.this.numberOfBuckets);
                    if (dBIDs == null) continue;
                    hashSetModifiableDBIDs.addDBIDs(dBIDs);
                }
                DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
                while (dBIDMIter.valid()) {
                    double d2 = this.distanceQuery.distance(v, dBIDMIter);
                    super.incRefinements(1);
                    if (d2 <= d) {
                        modifiableDoubleDBIDList.add(d2, dBIDMIter);
                    }
                    dBIDMIter.advance();
                }
            }
        }

        protected class LSHKNNQuery
        extends AbstractRefiningIndex.AbstractKNNQuery {
            public LSHKNNQuery(DistanceQuery<V> distanceQuery) {
                super(distanceQuery);
            }

            @Override
            public KNNList getKNNForObject(V v, int n) {
                Object object;
                ModifiableDBIDs modifiableDBIDs = null;
                int n2 = Instance.this.hashtables.size();
                double[] dArray = new double[Instance.this.hashfunctions.get(0).getNumberOfProjections()];
                for (int i = 0; i < n2; ++i) {
                    LocalitySensitiveHashFunction localitySensitiveHashFunction;
                    int n3;
                    int n4;
                    object = Instance.this.hashtables.get(i);
                    DBIDs dBIDs = (DBIDs)object.get(n4 = (n3 = (localitySensitiveHashFunction = Instance.this.hashfunctions.get(i)).hashObject(v, dArray)) % Instance.this.numberOfBuckets);
                    if (dBIDs == null) continue;
                    if (modifiableDBIDs == null) {
                        modifiableDBIDs = DBIDUtil.newHashSet(dBIDs.size() * n2 + n);
                    }
                    modifiableDBIDs.addDBIDs(dBIDs);
                }
                if (modifiableDBIDs == null) {
                    modifiableDBIDs = DBIDUtil.newArray();
                }
                KNNHeap kNNHeap = DBIDUtil.newHeap(n);
                object = modifiableDBIDs.iter();
                while (object.valid()) {
                    double d = this.distanceQuery.distance(v, object);
                    super.incRefinements(1);
                    kNNHeap.insert(d, (DBIDRef)object);
                    object.advance();
                }
                return kNNHeap.toKNNList();
            }
        }
    }
}

