/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import gnu.trove.map.hash.TObjectDoubleHashMap;

@Title(value="Partitioning Approximate kNN Preprocessor")
@Description(value="Caterializes the (approximate) k nearest neighbors of objects of a database by partitioning and only computing kNN within each partition.")
public class PartitionApproximationMaterializeKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(PartitionApproximationMaterializeKNNPreprocessor.class);
    private final int partitions;
    private final RandomFactory rnd;

    public PartitionApproximationMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n, int n2, RandomFactory randomFactory) {
        super(relation, distanceFunction, n);
        this.partitions = n2;
        this.rnd = randomFactory;
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = this.relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        MeanVariance meanVariance = new MeanVariance();
        if (LOG.isVerbose()) {
            LOG.verbose("Approximating nearest neighbor lists to database objects");
        }
        ArrayDBIDs[] arrayDBIDsArray = DBIDUtil.randomSplit(this.relation.getDBIDs(), this.partitions, this.rnd);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Processing partitions", this.partitions, LOG) : null;
        for (int i = 0; i < this.partitions; ++i) {
            ArrayDBIDs arrayDBIDs = arrayDBIDsArray[i];
            int n = arrayDBIDs.size();
            TObjectDoubleHashMap tObjectDoubleHashMap = new TObjectDoubleHashMap(n * n * 3 >> 3, 0.5f, Double.NaN);
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            while (dBIDArrayIter.valid()) {
                KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
                DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
                while (dBIDArrayIter2.valid()) {
                    DBIDPair dBIDPair = DBIDUtil.newPair(dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                    double d = tObjectDoubleHashMap.remove((Object)dBIDPair);
                    if (d == d) {
                        kNNHeap.insert(d, dBIDArrayIter2);
                    } else {
                        d = distanceQuery.distance((DBIDRef)dBIDArrayIter, (DBIDRef)dBIDArrayIter2);
                        kNNHeap.insert(d, dBIDArrayIter2);
                        dBIDPair = DBIDUtil.newPair(dBIDArrayIter2, (DBIDRef)dBIDArrayIter);
                        tObjectDoubleHashMap.put((Object)dBIDPair, d);
                    }
                    dBIDArrayIter2.advance();
                }
                meanVariance.put(kNNHeap.size());
                this.storage.put(dBIDArrayIter, kNNHeap.toKNNList());
                dBIDArrayIter.advance();
            }
            if (LOG.isDebugging() && tObjectDoubleHashMap.size() > 0) {
                LOG.warning("Cache should be empty after each run, but still has " + tObjectDoubleHashMap.size() + " elements.");
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        if (LOG.isVerbose()) {
            LOG.verbose("On average, " + meanVariance.getMean() + " +- " + meanVariance.getSampleStddev() + " neighbors returned.");
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "Random partition kNN approximation";
    }

    @Override
    public String getShortName() {
        return "random-partition-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        int partitions;
        private final RandomFactory rnd;

        public Factory(int n, DistanceFunction<? super O> distanceFunction, int n2, RandomFactory randomFactory) {
            super(n, distanceFunction);
            this.partitions = n2;
            this.rnd = randomFactory;
        }

        @Override
        public PartitionApproximationMaterializeKNNPreprocessor<O> instantiate(Relation<O> relation) {
            PartitionApproximationMaterializeKNNPreprocessor<O> partitionApproximationMaterializeKNNPreprocessor = new PartitionApproximationMaterializeKNNPreprocessor<O>(relation, this.distanceFunction, this.k, this.partitions, this.rnd);
            return partitionApproximationMaterializeKNNPreprocessor;
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            public static final OptionID PARTITIONS_ID = new OptionID("partknn.p", "The number of partitions to use for approximate kNN.");
            public static final OptionID SEED_ID = new OptionID("partknn.seed", "The random number generator seed.");
            protected int partitions = 0;
            private RandomFactory rnd;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                RandomParameter randomParameter;
                super.makeOptions(parameterization);
                IntParameter intParameter = new IntParameter(PARTITIONS_ID);
                intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.partitions = (Integer)intParameter.getValue();
                }
                if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                    this.rnd = (RandomFactory)randomParameter.getValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.partitions, this.rnd);
            }
        }
    }
}

