/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeFactory;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTreeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTreeNode;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class MkCopTreeFactory<O>
extends AbstractMTreeFactory<O, MkCoPTreeNode<O>, MkCoPEntry, MkCoPTreeIndex<O>, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry>> {
    public static final OptionID K_ID = new OptionID("mkcop.k", "positive integer specifying the maximum number k of reverse k nearest neighbors to be supported.");

    public MkCopTreeFactory(PageFileFactory<?> pageFileFactory, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry> mkTreeSettings) {
        super(pageFileFactory, mkTreeSettings);
    }

    @Override
    public MkCoPTreeIndex<O> instantiate(Relation<O> relation) {
        PageFile<MkCoPTreeNode<O>> pageFile = this.makePageFile(this.getNodeClass());
        return new MkCoPTreeIndex<O>(relation, pageFile, (MkTreeSettings)this.settings);
    }

    protected Class<MkCoPTreeNode<O>> getNodeClass() {
        return ClassGenericsUtil.uglyCastIntoSubclass(MkCoPTreeNode.class);
    }

    public static class Parameterizer<O>
    extends AbstractMTreeFactory.Parameterizer<O, MkCoPTreeNode<O>, MkCoPEntry, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry>> {
        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(K_ID);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                ((MkTreeSettings)this.settings).k_max = intParameter.intValue();
            }
        }

        @Override
        protected MkCopTreeFactory<O> makeInstance() {
            return new MkCopTreeFactory(this.pageFileFactory, (MkTreeSettings)this.settings);
        }

        @Override
        protected MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry> makeSettings() {
            return new MkTreeSettings();
        }
    }
}

